/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class FirePanicGoal
extends Goal {
    private final AbstractGoblinEntity goblin;
    private final double speed;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public FirePanicGoal(AbstractGoblinEntity goblin, double speedIn) {
        this.goblin = goblin;
        this.speed = speedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.goblin.func_70027_ad() && !this.goblin.isStunned()) {
            BlockPos blockpos = this.getClosestWaterPos((IBlockReader)this.goblin.field_70170_p, (Entity)this.goblin, 5, 4);
            if (blockpos != null) {
                this.randPosX = blockpos.func_177958_n();
                this.randPosY = blockpos.func_177956_o();
                this.randPosZ = blockpos.func_177952_p();
                return true;
            }
            return this.findRandomPosition();
        }
        return false;
    }

    public void func_75249_e() {
        this.goblin.func_70661_as().func_75492_a(this.randPosX, this.randPosY, this.randPosZ, this.speed);
    }

    public boolean func_75253_b() {
        return !this.goblin.func_70661_as().func_75500_f();
    }

    private boolean findRandomPosition() {
        Vector3d randomPos = RandomPositionGenerator.func_75463_a((CreatureEntity)this.goblin, (int)5, (int)4);
        if (randomPos == null) {
            return false;
        }
        this.randPosX = randomPos.field_72450_a;
        this.randPosY = randomPos.field_72448_b;
        this.randPosZ = randomPos.field_72449_c;
        return true;
    }

    @Nullable
    private BlockPos getClosestWaterPos(IBlockReader worldIn, Entity entityIn, int horizontalRange, int verticalRange) {
        BlockPos entityPos = entityIn.func_233580_cy_();
        int entityX = entityPos.func_177958_n();
        int entityY = entityPos.func_177956_o();
        int entityZ = entityPos.func_177952_p();
        float range = horizontalRange * horizontalRange * verticalRange * 2;
        BlockPos randomPos = null;
        BlockPos.Mutable currentPos = new BlockPos.Mutable();
        for (int x = entityX - horizontalRange; x <= entityX + horizontalRange; ++x) {
            for (int y = entityY - verticalRange; y <= entityY + verticalRange; ++y) {
                for (int z = entityZ - horizontalRange; z <= entityZ + horizontalRange; ++z) {
                    float f1;
                    currentPos.func_181079_c(x, y, z);
                    if (!worldIn.func_204610_c((BlockPos)currentPos).func_206884_a((ITag)FluidTags.field_206959_a) || !((f1 = (float)((x - entityX) * (x - entityX) + (y - entityY) * (y - entityY) + (z - entityZ) * (z - entityZ))) < range)) continue;
                    range = f1;
                    randomPos = new BlockPos((Vector3i)currentPos);
                }
            }
        }
        return randomPos;
    }
}

