/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncCurios;
import top.theillusivec4.curios.server.command.CurioArgumentType;

public class CuriosCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder curiosCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"curios").requires(player -> player.func_197034_c(2));
        curiosCommand.then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CuriosCommand.setSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.setSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CuriosCommand.growSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.growSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CuriosCommand.shrinkSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CuriosCommand.shrinkSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        curiosCommand.then(Commands.func_197057_a((String)"unlock").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CuriosCommand.unlockSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"))))));
        curiosCommand.then(Commands.func_197057_a((String)"lock").then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CuriosCommand.lockSlotForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"))))));
        curiosCommand.then(Commands.func_197057_a((String)"clear").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CuriosCommand.clearSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), ""))).then(Commands.func_197056_a((String)"slot", (ArgumentType)CurioArgumentType.slot()).executes(context -> CuriosCommand.clearSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), CurioArgumentType.getSlot((CommandContext<CommandSource>)context, "slot"))))));
        curiosCommand.then(Commands.func_197057_a((String)"reset").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CuriosCommand.resetSlotsForPlayer((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player")))));
        dispatcher.register(curiosCommand);
    }

    private static int setSlotsForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().setSlotsForType(slot, (LivingEntity)playerMP, amount);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.set.success", new Object[]{slot, CuriosApi.getSlotHelper().getSlotsForType((LivingEntity)playerMP, slot), playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int growSlotForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().growSlotType(slot, amount, (LivingEntity)playerMP);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.add.success", new Object[]{amount, slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int shrinkSlotForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot, int amount) {
        CuriosApi.getSlotHelper().shrinkSlotType(slot, amount, (LivingEntity)playerMP);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.remove.success", new Object[]{amount, slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int unlockSlotForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot) {
        CuriosApi.getSlotHelper().unlockSlotType(slot, (LivingEntity)playerMP);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.unlock.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int lockSlotForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot) {
        CuriosApi.getSlotHelper().lockSlotType(slot, (LivingEntity)playerMP);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.lock.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static int clearSlotsForPlayer(CommandSource source, ServerPlayerEntity playerMP, String slot) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            if (!slot.isEmpty() && curios.get(slot) != null) {
                CuriosCommand.clear(curios.get(slot));
            } else {
                for (String id : curios.keySet()) {
                    CuriosCommand.clear(curios.get(id));
                }
            }
        });
        if (slot.isEmpty()) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.clearAll.success", new Object[]{playerMP.func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.clear.success", new Object[]{slot, playerMP.func_145748_c_()}), true);
        }
        return 1;
    }

    private static int resetSlotsForPlayer(CommandSource source, ServerPlayerEntity playerMP) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerMP).ifPresent(handler -> {
            handler.reset();
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)new SPacketSyncCurios(playerMP.func_145782_y(), handler.getCurios()));
        });
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.curios.reset.success", new Object[]{playerMP.func_145748_c_()}), true);
        return 1;
    }

    private static void clear(ICurioStacksHandler stacksHandler) {
        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
            stacksHandler.getStacks().setStackInSlot(i, ItemStack.field_190927_a);
            stacksHandler.getCosmeticStacks().setStackInSlot(i, ItemStack.field_190927_a);
        }
    }
}

