/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes.common.capability;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioShulkerBox
implements ICurio {
    private static final String ANIMATION_TAG = "Animation";
    private static final String PROGRESS_TAG = "Progress";
    private static final String OLD_PROGRESS_TAG = "OldProgress";
    protected ItemStack stack;
    protected Object model;
    private ShulkerBoxTileEntity.AnimationStatus animationStatus = ShulkerBoxTileEntity.AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;

    public CurioShulkerBox(ItemStack stack) {
        this.stack = stack;
    }

    public void setAnimationStatus(ShulkerBoxTileEntity.AnimationStatus status) {
        this.animationStatus = status;
    }

    public float getProgress(float partialTicks) {
        return this.progressOld + (this.progress - this.progressOld) * partialTicks;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.OPENED;
                this.progress = 1.0f;
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.CLOSED;
                this.progress = 0.0f;
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public void playRightClickEquipSound(LivingEntity livingEntity) {
        livingEntity.field_70170_p.func_184133_a(null, new BlockPos(livingEntity.func_213303_ch()), SoundEvents.field_191261_fA, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public boolean canRightClickEquip() {
        return true;
    }

    public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
        return true;
    }

    @Nonnull
    public CompoundNBT writeSyncData() {
        CompoundNBT compound = new CompoundNBT();
        int state = 0;
        switch (this.animationStatus) {
            case OPENING: {
                state = 1;
                break;
            }
            case CLOSING: {
                state = 2;
                break;
            }
            case OPENED: {
                state = 3;
            }
        }
        compound.func_74768_a(ANIMATION_TAG, state);
        compound.func_74776_a(PROGRESS_TAG, this.progress);
        compound.func_74776_a(OLD_PROGRESS_TAG, this.progressOld);
        return compound;
    }

    public void readSyncData(CompoundNBT compound) {
        int state = compound.func_74762_e(ANIMATION_TAG);
        switch (state) {
            case 0: {
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.CLOSED;
                break;
            }
            case 1: {
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.OPENING;
                break;
            }
            case 2: {
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.CLOSING;
                break;
            }
            case 3: {
                this.animationStatus = ShulkerBoxTileEntity.AnimationStatus.OPENED;
            }
        }
        this.progress = compound.func_74760_g(PROGRESS_TAG);
        this.progressOld = compound.func_74760_g(OLD_PROGRESS_TAG);
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
        return true;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Direction direction = Direction.SOUTH;
        DyeColor color = ShulkerBoxBlock.func_190955_b((Item)this.stack.func_77973_b());
        RenderMaterial material = color == null ? Atlases.field_228748_g_ : (RenderMaterial)Atlases.field_228749_h_.get(color.func_196059_a());
        ICurio.RenderHelper.translateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
        ICurio.RenderHelper.rotateIfSneaking((MatrixStack)matrixStack, (LivingEntity)livingEntity);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        float f = 0.45f;
        matrixStack.func_227862_a_(f, f, f);
        matrixStack.func_227863_a_(direction.func_229384_a_());
        matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        matrixStack.func_227861_a_(-1.1125, -0.675, -0.5);
        IVertexBuilder ivertexbuilder = material.func_229311_a_(renderTypeBuffer, RenderType::func_228640_c_);
        if (!(this.model instanceof ShulkerModel)) {
            this.model = new ShulkerModel();
        }
        ShulkerModel model = (ShulkerModel)this.model;
        model.func_205069_a().func_228308_a_(matrixStack, ivertexbuilder, light, OverlayTexture.field_229196_a_);
        matrixStack.func_227861_a_(0.0, (double)(-this.getProgress(partialTicks) * 0.5f), 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f * this.getProgress(partialTicks)));
        model.func_205068_b().func_228308_a_(matrixStack, ivertexbuilder, light, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
    }
}

