/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javashared.prepare;

import java.util.HashMap;
import java.util.Map;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.annotations.NativeTag;
import org.openzen.zenscript.codemodel.definition.AliasDefinition;
import org.openzen.zenscript.codemodel.definition.ClassDefinition;
import org.openzen.zenscript.codemodel.definition.DefinitionVisitor;
import org.openzen.zenscript.codemodel.definition.EnumDefinition;
import org.openzen.zenscript.codemodel.definition.ExpansionDefinition;
import org.openzen.zenscript.codemodel.definition.FunctionDefinition;
import org.openzen.zenscript.codemodel.definition.InterfaceDefinition;
import org.openzen.zenscript.codemodel.definition.StructDefinition;
import org.openzen.zenscript.codemodel.definition.VariantDefinition;
import org.openzen.zenscript.codemodel.expression.CallExpression;
import org.openzen.zenscript.codemodel.expression.CallStaticExpression;
import org.openzen.zenscript.codemodel.expression.CastExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.member.InnerDefinitionMember;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaContext;
import org.openzen.zenscript.javashared.JavaMethod;
import org.openzen.zenscript.javashared.JavaNativeClass;
import org.openzen.zenscript.javashared.JavaVariantOption;

public class JavaPrepareDefinitionVisitor
implements DefinitionVisitor<JavaClass> {
    private final Map<String, JavaNativeClass> nativeClasses = new HashMap<String, JavaNativeClass>();
    private final JavaContext context;
    private final String filename;
    private final String className;
    private final JavaClass outerClass;
    private final JavaCompiledModule module;

    public JavaPrepareDefinitionVisitor(JavaContext context, JavaCompiledModule module, String filename, JavaClass outerClass) {
        this(context, module, filename, outerClass, JavaClass.getNameFromFile(filename));
    }

    public JavaPrepareDefinitionVisitor(JavaContext context, JavaCompiledModule module, String filename, JavaClass outerClass, String className) {
        JavaNativeClass cls = new JavaNativeClass(new JavaClass("java.lang", "StringBuilder", JavaClass.Kind.CLASS));
        cls.addConstructor("constructor", "()V");
        cls.addConstructor("constructorWithCapacity", "(I)V");
        cls.addConstructor("constructorWithValue", "(Ljava/lang/String;)V");
        cls.addMethod("isEmpty", new JavaMethod((expression, translator) -> translator.isEmptyAsLengthZero(((CallExpression)expression).target)));
        cls.addInstanceMethod("length", "length", "()I");
        cls.addInstanceMethod("appendBool", "append", "(Z)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendByte", "append", "(I)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendSByte", "append", "(B)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendShort", "append", "(S)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendUShort", "append", "(I)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendInt", "append", "(I)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendUInt", "append", "(I)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendLong", "append", "(J)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendULong", "append", "(J)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendUSize", "append", "(I)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendFloat", "append", "(F)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendDouble", "append", "(D)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendChar", "append", "(C)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("appendString", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        cls.addInstanceMethod("asString", "toString", "()Ljava/lang/String;");
        this.nativeClasses.put("stdlib::StringBuilder", cls);
        JavaNativeClass list = new JavaNativeClass(new JavaClass("java.util", "List", JavaClass.Kind.INTERFACE));
        JavaClass arrayList = new JavaClass("java.util", "ArrayList", JavaClass.Kind.CLASS);
        list.addMethod("constructor", JavaMethod.getNativeConstructor(arrayList, "()V"));
        list.addInstanceMethod("add", "add", "(Ljava/lang/Object;)Z");
        list.addInstanceMethod("insert", "add", "(ILjava/lang/Object;)V");
        list.addInstanceMethod("remove", "remove", "(I)Ljava/lang/Object;");
        list.addInstanceMethod("removeValue", "remove", "(Ljava/lang/Object;)Z");
        list.addInstanceMethod("indexOf", "indexOf", "(Ljava/lang/Object;)I");
        list.addInstanceMethod("lastIndexOf", "lastIndexOf", "(Ljava/lang/Object;)I");
        list.addInstanceMethod("getAtIndex", "get", "(I)Ljava/lang/Object;");
        list.addInstanceMethod("setAtIndex", "set", "(ILjava/lang/Object;)Ljava/lang/Object;");
        list.addInstanceMethod("contains", "contains", "(Ljava/lang/Object;)Z");
        list.addMethod("toArray", new JavaMethod((expression, translator) -> translator.listToArray((CastExpression)expression)));
        list.addInstanceMethod("length", "size", "()I");
        list.addInstanceMethod("isEmpty", "isEmpty", "()Z");
        list.addInstanceMethod("iterate", "iterator", "()Ljava/util/Iterator;");
        this.nativeClasses.put("stdlib::List", list);
        JavaNativeClass iterable = new JavaNativeClass(new JavaClass("java.lang", "Iterable", JavaClass.Kind.INTERFACE));
        iterable.addInstanceMethod("iterate", "iterator", "()Ljava/util/Iterator;");
        this.nativeClasses.put("stdlib::Iterable", iterable);
        JavaNativeClass iterator = new JavaNativeClass(new JavaClass("java.util", "Iterator", JavaClass.Kind.INTERFACE));
        iterator.addMethod("empty", new JavaMethod(JavaClass.COLLECTIONS, JavaMethod.Kind.STATIC, "emptyIterator", false, "()Ljava/lang/Iterator;", 9, false));
        iterator.addInstanceMethod("hasNext", "hasNext", "()Z");
        iterator.addInstanceMethod("next", "next", "()Ljava/lang/Object;");
        this.nativeClasses.put("stdlib::Iterator", iterator);
        JavaNativeClass comparable = new JavaNativeClass(new JavaClass("java.lang", "Comparable", JavaClass.Kind.INTERFACE));
        comparable.addInstanceMethod("compareTo", "compareTo", "(Ljava/lang/Object;)I");
        this.nativeClasses.put("stdlib::Comparable", comparable);
        JavaClass integer = new JavaClass("java.lang", "Integer", JavaClass.Kind.CLASS);
        JavaClass math = new JavaClass("java.lang", "Math", JavaClass.Kind.CLASS);
        JavaNativeClass cls2 = new JavaNativeClass(integer);
        cls2.addMethod("min", JavaMethod.getNativeStatic(math, "min", "(II)I"));
        cls2.addMethod("max", JavaMethod.getNativeStatic(math, "max", "(II)I"));
        cls2.addMethod("toHexString", JavaMethod.getNativeExpansion(integer, "toHexString", "(I)Ljava/lang/String;"));
        this.nativeClasses.put("stdlib::Integer", cls2);
        this.nativeClasses.put("stdlib::USize", cls2);
        JavaClass string = new JavaClass("java.lang", "String", JavaClass.Kind.CLASS);
        JavaNativeClass cls3 = new JavaNativeClass(string);
        cls3.addMethod("contains", new JavaMethod((expression, translator) -> {
            CallExpression call = (CallExpression)expression;
            Expression str = call.target;
            Expression character = call.arguments.arguments[0];
            return translator.containsAsIndexOf(str, character);
        }));
        cls3.addInstanceMethod("indexOfFrom", "indexOf", "(II)I");
        cls3.addInstanceMethod("lastIndexOf", "lastIndexOf", "(I)I");
        cls3.addInstanceMethod("lastIndexOfFrom", "lastIndexOf", "(II)I");
        cls3.addInstanceMethod("indexOf", "indexOf", "(I)I");
        cls3.addInstanceMethod("indexOfString", "indexOf", "(Ljava/lang/String;)I");
        cls3.addInstanceMethod("indexOfStringFrom", "indexOf", "(Ljava/lang/String;I)I");
        cls3.addInstanceMethod("lastIndexOfString", "lastIndexOf", "(Ljava/lang/String;)I");
        cls3.addInstanceMethod("lastIndexOfStringFrom", "lastIndexOf", "(Ljava/lang/String;I)I");
        cls3.addInstanceMethod("trim", "trim", "()Ljava/lang/String;");
        cls3.addInstanceMethod("startsWith", "startsWith", "(Ljava/lang/String;)Z");
        cls3.addInstanceMethod("endsWith", "endsWith", "(Ljava/lang/String;)Z");
        cls3.addMethod("fromAsciiBytes", new JavaMethod((expression, translator) -> {
            CallStaticExpression call = (CallStaticExpression)expression;
            return translator.bytesAsciiToString(call.arguments.arguments[0]);
        }));
        cls3.addMethod("fromUTF8Bytes", new JavaMethod((expression, translator) -> {
            CallStaticExpression call = (CallStaticExpression)expression;
            return translator.bytesUTF8ToString(call.arguments.arguments[0]);
        }));
        cls3.addMethod("toAsciiBytes", new JavaMethod((expression, translator) -> {
            CallExpression call = (CallExpression)expression;
            return translator.stringToAscii(call.target);
        }));
        cls3.addMethod("toUTF8Bytes", new JavaMethod((expression, translator) -> {
            CallExpression call = (CallExpression)expression;
            return translator.stringToUTF8(call.target);
        }));
        this.nativeClasses.put("stdlib::String", cls3);
        JavaClass arrays = JavaClass.ARRAYS;
        cls3 = new JavaNativeClass(arrays);
        cls3.addMethod("sort", JavaMethod.getNativeExpansion(arrays, "sort", "([Ljava/lang/Object;)[Ljava/lang/Object;"));
        cls3.addMethod("sorted", new JavaMethod((expression, translator) -> translator.sorted(((CallExpression)expression).target)));
        cls3.addMethod("sortWithComparator", JavaMethod.getNativeExpansion(arrays, "sort", "([Ljava/lang/Object;Ljava/util/Comparator;)V"));
        cls3.addMethod("sortedWithComparator", new JavaMethod((expression, translator) -> translator.sortedWithComparator(((CallExpression)expression).target, ((CallExpression)expression).arguments.arguments[0])));
        cls3.addMethod("copy", new JavaMethod((expression, translator) -> translator.arrayCopy(((CallExpression)expression).target)));
        cls3.addMethod("copyResize", new JavaMethod((expression, translator) -> translator.arrayCopyResize((CallExpression)expression)));
        cls3.addMethod("copyTo", new JavaMethod((expression, translator) -> translator.arrayCopyTo((CallExpression)expression)));
        this.nativeClasses.put("stdlib::Arrays", cls3);
        cls = new JavaNativeClass(new JavaClass("java.lang", "IllegalArgumentException", JavaClass.Kind.CLASS));
        cls.addConstructor("constructor", "(Ljava/lang/String;)V");
        this.nativeClasses.put("stdlib::IllegalArgumentException", cls);
        cls = new JavaNativeClass(new JavaClass("java.lang", "Exception", JavaClass.Kind.CLASS));
        cls.addConstructor("constructor", "(Ljava/lang/String;)V");
        cls.addConstructor("constructorWithCause", "(Ljava/lang/String;Ljava/lang/Throwable;)V");
        this.nativeClasses.put("stdlib::Exception", cls);
        cls = new JavaNativeClass(new JavaClass("java.io", "IOException", JavaClass.Kind.CLASS));
        cls.addConstructor("constructor", "(Ljava/lang/String;)V");
        this.nativeClasses.put("io::IOException", cls);
        cls = new JavaNativeClass(new JavaClass("java.io", "Reader", JavaClass.Kind.INTERFACE));
        cls.addInstanceMethod("destruct", "close", "()V");
        cls.addInstanceMethod("readCharacter", "read", "()C");
        cls.addInstanceMethod("readArray", "read", "([C)I");
        cls.addInstanceMethod("readArraySlice", "read", "([CII)I");
        this.nativeClasses.put("io::Reader", cls);
        cls = new JavaNativeClass(new JavaClass("java.io", "StringReader", JavaClass.Kind.CLASS), true);
        cls.addConstructor("constructor", "(Ljava/lang/String;)V");
        cls.addInstanceMethod("destructor", "close", "()V");
        cls.addInstanceMethod("readCharacter", "read", "()C");
        cls.addInstanceMethod("readArray", "read", "([C)I");
        cls.addInstanceMethod("readSlice", "read", "([CII)I");
        this.nativeClasses.put("io::StringReader", cls);
        cls = new JavaNativeClass(new JavaClass("java.io", "InputStream", JavaClass.Kind.INTERFACE), true);
        cls.addInstanceMethod("destructor", "close", "()V");
        cls.addInstanceMethod("read", "read", "()I");
        cls.addInstanceMethod("readArray", "read", "([B)I");
        cls.addInstanceMethod("readSlice", "read", "([BII)I");
        this.nativeClasses.put("io::InputStream", cls);
        cls = new JavaNativeClass(new JavaClass("java.io", "OutputStream", JavaClass.Kind.INTERFACE), true);
        cls.addInstanceMethod("destructor", "close", "()V");
        cls.addInstanceMethod("write", "write", "()I");
        cls.addInstanceMethod("writeArray", "write", "([B)V");
        cls.addInstanceMethod("writeSlice", "write", "([BII)V");
        this.nativeClasses.put("io::OutputStream", cls);
        JavaClass math2 = new JavaClass("java.lang", "Math", JavaClass.Kind.CLASS);
        JavaNativeClass mathFunctions = new JavaNativeClass(math2, true);
        for (String doubleToDoubleMethodName : new String[]{"sin", "cos", "tan", "asin", "acos", "atan", "sinh", "cosh", "tanh", "toRadians", "toDegrees", "exp", "log", "log10", "sqrt", "cbrt", "ceil", "floor", "abs", "signum"}) {
            mathFunctions.addMethod(doubleToDoubleMethodName, JavaMethod.getNativeStatic(math2, doubleToDoubleMethodName, "(D)D"));
        }
        mathFunctions.addMethod("minInteger", JavaMethod.getNativeStatic(math2, "min", "(II)I"));
        mathFunctions.addMethod("maxInteger", JavaMethod.getNativeStatic(math2, "max", "(II)I"));
        mathFunctions.addMethod("minLong", JavaMethod.getNativeStatic(math2, "min", "(JJ)J"));
        mathFunctions.addMethod("maxLong", JavaMethod.getNativeStatic(math2, "max", "(JJ)J"));
        mathFunctions.addMethod("minFloat", JavaMethod.getNativeStatic(math2, "min", "(FF)F"));
        mathFunctions.addMethod("maxFloat", JavaMethod.getNativeStatic(math2, "max", "(FF)F"));
        mathFunctions.addMethod("minDouble", JavaMethod.getNativeStatic(math2, "min", "(DD)D"));
        mathFunctions.addMethod("maxDouble", JavaMethod.getNativeStatic(math2, "max", "(DD)D"));
        mathFunctions.addMethod("roundDouble", JavaMethod.getNativeStatic(math2, "round", "(D)J"));
        mathFunctions.addMethod("roundFloat", JavaMethod.getNativeStatic(math2, "round", "(F)J"));
        mathFunctions.addMethod("absInteger", JavaMethod.getNativeStatic(math2, "abs", "(I)I"));
        mathFunctions.addMethod("pow", JavaMethod.getNativeStatic(math2, "pow", "(DD)D"));
        this.nativeClasses.put("math::Functions", mathFunctions);
        this.context = context;
        this.filename = filename;
        this.outerClass = outerClass;
        this.module = module;
        this.className = className;
    }

    private boolean isPrepared(HighLevelDefinition definition) {
        return this.context.hasJavaClass(definition);
    }

    public void prepare(TypeID type) {
        if (!(type instanceof DefinitionTypeID)) {
            return;
        }
        HighLevelDefinition definition = ((DefinitionTypeID)type).definition;
        definition.accept(this);
    }

    @Override
    public JavaClass visitClass(ClassDefinition definition) {
        if (this.isPrepared(definition)) {
            return this.context.getJavaClass(definition);
        }
        return this.visitClassCompiled(definition, true, JavaClass.Kind.CLASS);
    }

    @Override
    public JavaClass visitInterface(InterfaceDefinition definition) {
        if (this.isPrepared(definition)) {
            return this.context.getJavaClass(definition);
        }
        for (TypeID baseType : definition.baseInterfaces) {
            this.prepare(baseType);
        }
        return this.visitClassCompiled(definition, true, JavaClass.Kind.INTERFACE);
    }

    @Override
    public JavaClass visitEnum(EnumDefinition definition) {
        if (this.isPrepared(definition)) {
            return this.context.getJavaClass(definition);
        }
        return this.visitClassCompiled(definition, false, JavaClass.Kind.ENUM);
    }

    @Override
    public JavaClass visitStruct(StructDefinition definition) {
        if (this.isPrepared(definition)) {
            return this.context.getJavaClass(definition);
        }
        return this.visitClassCompiled(definition, true, JavaClass.Kind.CLASS);
    }

    @Override
    public JavaClass visitFunction(FunctionDefinition definition) {
        if (this.isPrepared(definition)) {
            return this.context.getJavaClass(definition);
        }
        JavaClass cls = new JavaClass(this.context.getPackageName(definition.pkg), this.className, JavaClass.Kind.CLASS);
        this.context.setJavaClass(definition, cls);
        return cls;
    }

    @Override
    public JavaClass visitExpansion(ExpansionDefinition definition) {
        if (this.isPrepared(definition)) {
            return this.context.getJavaClass(definition);
        }
        NativeTag nativeTag = definition.getTag(NativeTag.class);
        if (nativeTag != null) {
            this.context.setJavaNativeClass(definition, this.nativeClasses.get(nativeTag.value));
        }
        JavaClass cls = new JavaClass(this.context.getPackageName(definition.pkg), this.className, JavaClass.Kind.CLASS);
        this.context.setJavaClass(definition, cls);
        return cls;
    }

    @Override
    public JavaClass visitAlias(AliasDefinition definition) {
        return null;
    }

    @Override
    public JavaClass visitVariant(VariantDefinition variant) {
        if (this.isPrepared(variant)) {
            return this.context.getJavaClass(variant);
        }
        JavaClass cls = new JavaClass(this.context.getPackageName(variant.pkg), variant.name, JavaClass.Kind.CLASS);
        this.context.setJavaClass(variant, cls);
        for (VariantDefinition.Option option : variant.options) {
            JavaClass variantCls = new JavaClass(cls, option.name, JavaClass.Kind.CLASS);
            this.module.setVariantOption(option, new JavaVariantOption(cls, variantCls));
        }
        return cls;
    }

    private JavaClass visitClassCompiled(HighLevelDefinition definition, boolean startsEmpty, JavaClass.Kind kind) {
        JavaClass cls;
        NativeTag nativeTag;
        JavaNativeClass nativeClass;
        if (definition.getSuperType() != null) {
            this.prepare(definition.getSuperType());
        }
        JavaNativeClass javaNativeClass = nativeClass = (nativeTag = definition.getTag(NativeTag.class)) == null ? null : this.nativeClasses.get(nativeTag.value);
        if (nativeClass == null) {
            cls = this.outerClass == null ? new JavaClass(this.context.getPackageName(definition.pkg), definition.name, kind) : new JavaClass(this.outerClass, definition.name, kind);
            this.context.setJavaClass(definition, cls);
        } else {
            cls = this.outerClass == null ? new JavaClass(this.context.getPackageName(definition.pkg), definition.name + "Expansion", kind) : new JavaClass(this.outerClass, definition.name + "Expansion", kind);
            this.context.setJavaClass(definition, nativeClass.cls);
            this.context.setJavaExpansionClass(definition, cls);
            this.context.setJavaNativeClass(definition, nativeClass);
        }
        for (IDefinitionMember member : definition.members) {
            if (!(member instanceof InnerDefinitionMember)) continue;
            ((InnerDefinitionMember)member).innerDefinition.accept(new JavaPrepareDefinitionVisitor(this.context, this.module, this.filename, cls));
        }
        return cls;
    }
}

