/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javashared;

import java.util.Arrays;
import org.openzen.zenscript.codemodel.generic.ParameterTypeBound;
import org.openzen.zenscript.codemodel.generic.TypeParameterBound;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.AssocTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.FunctionTypeID;
import org.openzen.zenscript.codemodel.type.GenericMapTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.IteratorTypeID;
import org.openzen.zenscript.codemodel.type.OptionalTypeID;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaContext;
import org.openzen.zenscript.javashared.types.JavaFunctionalInterfaceTypeID;

public class JavaTypeDescriptorVisitor
implements TypeVisitor<String> {
    private final JavaTypeDescriptorVisitor forOptional;
    private final JavaContext context;
    private final boolean optional;

    public JavaTypeDescriptorVisitor(JavaContext context) {
        this(context, false);
    }

    private JavaTypeDescriptorVisitor(JavaContext context, boolean optional) {
        this.optional = optional;
        this.context = context;
        this.forOptional = optional ? this : new JavaTypeDescriptorVisitor(context, true);
    }

    public String process(TypeID type) {
        return type.accept(this);
    }

    @Override
    public String visitBasic(BasicTypeID basic) {
        if (this.optional) {
            switch (basic) {
                case BOOL: {
                    return "Ljava/lang/Boolean;";
                }
                case CHAR: {
                    return "Ljava/lang/Character;";
                }
                case BYTE: {
                    return "Ljava/lang/Integer;";
                }
                case SBYTE: {
                    return "Ljava/lang/Byte;";
                }
                case SHORT: {
                    return "Ljava/lang/Short;";
                }
                case USHORT: {
                    return "Ljava/lang/Integer;";
                }
                case INT: {
                    return "Ljava/lang/Integer;";
                }
                case UINT: {
                    return "Ljava/lang/Integer;";
                }
                case LONG: {
                    return "Ljava/lang/Long;";
                }
                case ULONG: {
                    return "Ljava/lang/Long;";
                }
                case USIZE: {
                    return "I";
                }
                case FLOAT: {
                    return "Ljava/lang/Float;";
                }
                case DOUBLE: {
                    return "Ljava/lang/Double;";
                }
                case STRING: {
                    return "Ljava/lang/String;";
                }
            }
            throw new IllegalArgumentException("Not a valid type: " + basic);
        }
        switch (basic) {
            case VOID: {
                return "V";
            }
            case BOOL: {
                return "Z";
            }
            case CHAR: {
                return "C";
            }
            case BYTE: {
                return "I";
            }
            case SBYTE: {
                return "B";
            }
            case SHORT: {
                return "S";
            }
            case USHORT: {
                return "I";
            }
            case INT: {
                return "I";
            }
            case UINT: {
                return "I";
            }
            case LONG: {
                return "J";
            }
            case ULONG: {
                return "J";
            }
            case USIZE: {
                return "I";
            }
            case FLOAT: {
                return "F";
            }
            case DOUBLE: {
                return "D";
            }
            case STRING: {
                return "Ljava/lang/String;";
            }
        }
        throw new IllegalArgumentException("Not a valid type: " + basic);
    }

    @Override
    public String visitArray(ArrayTypeID array) {
        if (array.elementType == BasicTypeID.BYTE) {
            return "[B";
        }
        if (array.elementType == BasicTypeID.USHORT) {
            return "[S";
        }
        char[] arrayDepth = new char[array.dimension];
        Arrays.fill(arrayDepth, '[');
        return new String(arrayDepth) + this.context.getDescriptor(array.elementType);
    }

    @Override
    public String visitAssoc(AssocTypeID assoc) {
        return "Ljava/util/Map;";
    }

    @Override
    public String visitIterator(IteratorTypeID iterator) {
        return "Ljava/lang/Iterator;";
    }

    @Override
    public String visitFunction(FunctionTypeID function) {
        if (function instanceof JavaFunctionalInterfaceTypeID) {
            return "L" + ((JavaFunctionalInterfaceTypeID)function).method.cls.internalName + ";";
        }
        return "L" + this.context.getFunction((FunctionTypeID)function).getCls().internalName + ";";
    }

    @Override
    public String visitDefinition(DefinitionTypeID definition) {
        JavaClass cls = this.context.getJavaClass(definition.definition);
        return "L" + cls.internalName + ";";
    }

    @Override
    public String visitGeneric(GenericTypeID generic) {
        for (TypeParameterBound bound : generic.parameter.bounds) {
            if (!(bound instanceof ParameterTypeBound)) continue;
            return this.process(((ParameterTypeBound)bound).type);
        }
        return "Ljava/lang/Object;";
    }

    @Override
    public String visitRange(RangeTypeID range) {
        return "L" + this.context.getRange((RangeTypeID)range).cls.internalName + ";";
    }

    @Override
    public String visitOptional(OptionalTypeID modified) {
        return modified.withoutOptional().accept(this.forOptional);
    }

    @Override
    public String visitGenericMap(GenericMapTypeID map) {
        return "Ljava/util/Map;";
    }
}

