/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zencode.java.module.converters;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.java.module.JavaNativeModule;
import org.openzen.zencode.java.module.JavaNativeTypeConversionContext;
import org.openzen.zencode.java.module.TypeVariableContext;
import org.openzen.zencode.java.module.converters.JavaNativeHeaderConverter;
import org.openzen.zencode.java.module.converters.JavaNativePackageInfo;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.LiteralSourceFile;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.annotations.AnnotationDefinition;
import org.openzen.zenscript.codemodel.context.CompilingPackage;
import org.openzen.zenscript.codemodel.context.ModuleTypeResolutionContext;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.generic.ParameterTypeBound;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaMethod;
import org.openzen.zenscript.javashared.types.JavaFunctionalInterfaceTypeID;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.type.IParsedType;

public class JavaNativeTypeConverter {
    private final Map<Class<?>, TypeID> typeByClass = new HashMap();
    private final Map<Class<?>, TypeID> unsignedByClass = new HashMap();
    private final JavaNativePackageInfo packageInfo;
    private final JavaNativeModule javaNativeModule;
    private final JavaNativeTypeConversionContext typeConversionContext;
    private BracketExpressionParser bep;
    private JavaNativeHeaderConverter headerConverter;

    public JavaNativeTypeConverter(JavaNativeTypeConversionContext typeConversionContext, JavaNativePackageInfo packageInfo, JavaNativeModule javaNativeModule) {
        this.typeConversionContext = typeConversionContext;
        this.packageInfo = packageInfo;
        this.javaNativeModule = javaNativeModule;
        this.fillByClassMaps();
    }

    public TypeID loadStoredType(TypeVariableContext context, AnnotatedType annotatedType) {
        return this.loadType(context, annotatedType);
    }

    public TypeID loadStoredType(TypeVariableContext context, Parameter parameter) {
        TypeID type = this.loadStoredType(context, parameter.getAnnotatedType());
        if (parameter.isAnnotationPresent(ZenCodeType.Optional.class) && !type.isOptional()) {
            return this.typeConversionContext.registry.getOptional(type);
        }
        return type;
    }

    public TypeID loadType(TypeVariableContext context, AnnotatedType annotatedType) {
        if (annotatedType.isAnnotationPresent(ZenCodeType.USize.class)) {
            return BasicTypeID.USIZE;
        }
        if (annotatedType.isAnnotationPresent(ZenCodeType.NullableUSize.class)) {
            return this.typeConversionContext.registry.getOptional(BasicTypeID.USIZE);
        }
        boolean nullable = annotatedType.isAnnotationPresent(ZenCodeType.Nullable.class) || annotatedType.isAnnotationPresent(ZenCodeType.Optional.class);
        boolean unsigned = annotatedType.isAnnotationPresent(ZenCodeType.Unsigned.class);
        return this.loadType(context, annotatedType, nullable, unsigned);
    }

    public TypeID loadType(TypeVariableContext context, AnnotatedElement type, boolean nullable, boolean unsigned) {
        TypeID result = this.loadType(context, type, unsigned);
        if (nullable) {
            result = this.typeConversionContext.registry.getOptional(result);
        }
        return result;
    }

    public TypeID loadType(TypeVariableContext context, AnnotatedElement type, boolean unsigned) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (unsigned) {
                if (this.unsignedByClass.containsKey(classType)) {
                    return this.unsignedByClass.get(classType);
                }
                throw new IllegalArgumentException("This class cannot be used as unsigned: " + classType);
            }
            if (classType.isArray()) {
                return this.typeConversionContext.registry.getArray(this.loadType(context, classType.getComponentType(), false, false), 1);
            }
            if (classType.isAnnotationPresent(FunctionalInterface.class)) {
                return this.loadFunctionalInterface(context, classType, new AnnotatedElement[0]);
            }
            if (this.typeByClass.containsKey(classType)) {
                return this.typeByClass.get(classType);
            }
            HighLevelDefinition definition = this.javaNativeModule.addClass(classType);
            ArrayList<GenericTypeID> s = new ArrayList<GenericTypeID>();
            for (TypeVariable typeParameter : classType.getTypeParameters()) {
                s.add(this.typeConversionContext.registry.getGeneric(context.get(typeParameter)));
            }
            return this.typeConversionContext.registry.getForDefinition(definition, s.toArray(TypeID.NONE));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)((Object)type);
            Class rawType = (Class)parameterizedType.getRawType();
            if (rawType.isAnnotationPresent(FunctionalInterface.class)) {
                return this.loadFunctionalInterface(context, rawType, (AnnotatedElement[])parameterizedType.getActualTypeArguments());
            }
            Type[] parameters = parameterizedType.getActualTypeArguments();
            TypeID[] codeParameters = new TypeID[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                codeParameters[i] = this.loadType(context, (AnnotatedElement)((Object)parameters[i]), false, false);
            }
            if (rawType == Map.class) {
                return this.typeConversionContext.registry.getAssociative(codeParameters[0], codeParameters[1]);
            }
            HighLevelDefinition definition = this.javaNativeModule.addClass(rawType);
            return this.typeConversionContext.registry.getForDefinition(definition, codeParameters);
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            return this.typeConversionContext.registry.getGeneric(context.get(variable));
        }
        if (type instanceof AnnotatedType) {
            TypeID storedType;
            if (type instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
                Type rawType = ((ParameterizedType)parameterizedType.getType()).getRawType();
                AnnotatedType[] actualTypeArguments = parameterizedType.getAnnotatedActualTypeArguments();
                TypeID[] codeParameters = new TypeID[actualTypeArguments.length];
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    codeParameters[i] = this.loadType(context, actualTypeArguments[i], false, false);
                }
                if (rawType == Map.class) {
                    storedType = this.typeConversionContext.registry.getAssociative(codeParameters[0], codeParameters[1]);
                } else if (rawType instanceof Class) {
                    HashMap<TypeParameter, TypeID> map = new HashMap<TypeParameter, TypeID>();
                    TypeVariable<Class<T>>[] typeParameters = ((Class)rawType).getTypeParameters();
                    TypeID loadType = this.loadType(context, (AnnotatedElement)((Object)rawType), unsigned);
                    for (int i = 0; i < typeParameters.length; ++i) {
                        TypeParameter typeParameter = context.get(typeParameters[i]);
                        map.put(typeParameter, codeParameters[i]);
                    }
                    storedType = loadType.instance(new GenericMapper(CodePosition.NATIVE, this.typeConversionContext.registry, map));
                } else {
                    storedType = this.loadType(context, (AnnotatedElement)((Object)rawType), unsigned);
                }
            } else {
                Type annotatedTypeType = ((AnnotatedType)type).getType();
                if (annotatedTypeType instanceof WildcardType) {
                    storedType = BasicTypeID.UNDETERMINED;
                } else if (annotatedTypeType instanceof GenericArrayType) {
                    Type genericComponentType = ((GenericArrayType)annotatedTypeType).getGenericComponentType();
                    TypeID baseType = this.loadType(context, (AnnotatedElement)((Object)genericComponentType), unsigned);
                    storedType = this.typeConversionContext.registry.getArray(baseType, 1);
                } else {
                    storedType = this.loadType(context, (AnnotatedElement)((Object)annotatedTypeType), unsigned);
                }
            }
            return storedType;
        }
        throw new IllegalArgumentException("Could not analyze type: " + type);
    }

    public Class<?> getClassFromType(TypeID type) {
        if (type instanceof DefinitionTypeID) {
            DefinitionTypeID definitionType = (DefinitionTypeID)type;
            for (Map.Entry<Class<?>, HighLevelDefinition> ent : this.typeConversionContext.definitionByClass.entrySet()) {
                if (!ent.getValue().equals(definitionType.definition)) continue;
                return ent.getKey();
            }
        }
        for (Map.Entry<Class<?>, TypeID> ent : this.typeByClass.entrySet()) {
            if (!ent.getValue().equals(type)) continue;
            return ent.getKey();
        }
        for (Map.Entry<Class<?>, TypeID> ent : this.unsignedByClass.entrySet()) {
            if (!ent.getValue().equals(type)) continue;
            return ent.getKey();
        }
        return null;
    }

    public TypeID getTypeFromName(String className) {
        for (TypeID value : this.typeByClass.values()) {
            if (!value.toString().equals(className)) continue;
            return value;
        }
        for (TypeID value : this.unsignedByClass.values()) {
            if (!value.toString().equals(className)) continue;
            return value;
        }
        try {
            ZSPackage zsPackage = this.packageInfo.getPackage(className);
            String[] split = className.split("\\.");
            String actualName = split[split.length - 1];
            for (HighLevelDefinition value : this.typeConversionContext.definitionByClass.values()) {
                if (!actualName.equals(value.name) || !value.pkg.equals(zsPackage)) continue;
                return this.typeConversionContext.registry.getForMyDefinition(value);
            }
        }
        catch (IllegalArgumentException zsPackage) {
            // empty catch block
        }
        CompilingPackage rootCompiling = new CompilingPackage(this.packageInfo.getPkg().parent, this.packageInfo.getModule());
        ModuleTypeResolutionContext context = new ModuleTypeResolutionContext(this.typeConversionContext.registry, new AnnotationDefinition[0], this.packageInfo.getPkg().parent, rootCompiling, this.typeConversionContext.globals);
        try {
            ZSTokenParser tokens = ZSTokenParser.create(new LiteralSourceFile("type reading: " + className, className), this.bep);
            return IParsedType.parse(tokens).compile(context);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private TypeID loadFunctionalInterface(TypeVariableContext loadContext, Class<?> cls, AnnotatedElement[] parameters) {
        Method functionalInterfaceMethod = this.getFunctionalInterfaceMethod(cls);
        TypeVariableContext context = this.convertTypeParameters(cls);
        FunctionHeader header = this.headerConverter.getHeader(context, functionalInterfaceMethod);
        HashMap<TypeParameter, TypeID> mapping = new HashMap<TypeParameter, TypeID>();
        TypeVariable<Class<?>>[] javaParameters = cls.getTypeParameters();
        for (int i = 0; i < parameters.length; ++i) {
            mapping.put(context.get(javaParameters[i]), this.loadType(loadContext, parameters[i], false, false));
        }
        header = header.withGenericArguments(new GenericMapper(CodePosition.NATIVE, this.typeConversionContext.registry, mapping));
        JavaMethod method = new JavaMethod(JavaClass.fromInternalName(org.objectweb.asm.Type.getInternalName(cls), JavaClass.Kind.INTERFACE), JavaMethod.Kind.INTERFACE, functionalInterfaceMethod.getName(), false, org.objectweb.asm.Type.getMethodDescriptor((Method)functionalInterfaceMethod), 1025, header.getReturnType().isGeneric());
        return new JavaFunctionalInterfaceTypeID(this.typeConversionContext.registry, header, functionalInterfaceMethod, method);
    }

    private void fillByClassMaps() {
        this.typeByClass.put(Void.TYPE, BasicTypeID.VOID);
        this.typeByClass.put(Boolean.TYPE, BasicTypeID.BOOL);
        this.typeByClass.put(Byte.TYPE, BasicTypeID.SBYTE);
        this.typeByClass.put(Character.TYPE, BasicTypeID.CHAR);
        this.typeByClass.put(Short.TYPE, BasicTypeID.SHORT);
        this.typeByClass.put(Integer.TYPE, BasicTypeID.INT);
        this.typeByClass.put(Long.TYPE, BasicTypeID.LONG);
        this.typeByClass.put(Float.TYPE, BasicTypeID.FLOAT);
        this.typeByClass.put(Double.TYPE, BasicTypeID.DOUBLE);
        this.typeByClass.put(String.class, BasicTypeID.STRING);
        this.typeByClass.put(Boolean.class, this.typeConversionContext.registry.getOptional(BasicTypeID.BOOL));
        this.typeByClass.put(Byte.class, this.typeConversionContext.registry.getOptional(BasicTypeID.BYTE));
        this.typeByClass.put(Short.class, this.typeConversionContext.registry.getOptional(BasicTypeID.SHORT));
        this.typeByClass.put(Integer.class, this.typeConversionContext.registry.getOptional(BasicTypeID.INT));
        this.typeByClass.put(Long.class, this.typeConversionContext.registry.getOptional(BasicTypeID.LONG));
        this.typeByClass.put(Float.class, this.typeConversionContext.registry.getOptional(BasicTypeID.FLOAT));
        this.typeByClass.put(Double.class, this.typeConversionContext.registry.getOptional(BasicTypeID.DOUBLE));
        this.unsignedByClass.put(Byte.TYPE, BasicTypeID.BYTE);
        this.unsignedByClass.put(Character.TYPE, BasicTypeID.CHAR);
        this.unsignedByClass.put(Short.TYPE, BasicTypeID.USHORT);
        this.unsignedByClass.put(Integer.TYPE, BasicTypeID.UINT);
        this.unsignedByClass.put(Long.TYPE, BasicTypeID.ULONG);
        this.unsignedByClass.put(Byte.class, this.typeConversionContext.registry.getOptional(BasicTypeID.BYTE));
        this.unsignedByClass.put(Short.class, this.typeConversionContext.registry.getOptional(BasicTypeID.SHORT));
        this.unsignedByClass.put(Integer.class, this.typeConversionContext.registry.getOptional(BasicTypeID.INT));
        this.unsignedByClass.put(Long.class, this.typeConversionContext.registry.getOptional(BasicTypeID.LONG));
    }

    public void setBEP(BracketExpressionParser bep) {
        this.bep = bep;
    }

    private <T> TypeVariableContext convertTypeParameters(Class<T> cls) {
        int i;
        TypeVariable<Class<T>>[] javaTypeParameters = cls.getTypeParameters();
        TypeParameter[] typeParameters = new TypeParameter[cls.getTypeParameters().length];
        for (i = 0; i < javaTypeParameters.length; ++i) {
            TypeVariable<Class<T>> typeVariable = javaTypeParameters[i];
            TypeParameter parameter = new TypeParameter(CodePosition.NATIVE, typeVariable.getName());
            for (AnnotatedType bound : typeVariable.getAnnotatedBounds()) {
                TypeID type = this.loadType(this.typeConversionContext.context, bound);
                parameter.addBound(new ParameterTypeBound(CodePosition.NATIVE, type));
            }
            typeParameters[i] = parameter;
            this.typeConversionContext.context.put(typeVariable, parameter);
        }
        for (i = 0; i < javaTypeParameters.length; ++i) {
            for (AnnotatedType bound : javaTypeParameters[i].getAnnotatedBounds()) {
                TypeID type = this.loadType(this.typeConversionContext.context, bound);
                typeParameters[i].addBound(new ParameterTypeBound(CodePosition.NATIVE, type));
            }
        }
        return this.typeConversionContext.context;
    }

    private Method getFunctionalInterfaceMethod(Class<?> functionalInterface) {
        for (Method method : functionalInterface.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isAbstract(method.getModifiers()) || method.isDefault()) continue;
            return method;
        }
        throw new IllegalArgumentException("Could not find functionalInterface method for class " + functionalInterface.getCanonicalName());
    }

    public void setHeaderConverter(JavaNativeHeaderConverter headerConverter) {
        this.headerConverter = headerConverter;
    }
}

