/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagAdd;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagCreate;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagRemove;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tags/TagManagerFluid")
@ZenCodeType.Name(value="crafttweaker.api.tag.TagManagerFluid")
public class TagManagerFluid
implements TagManager<Fluid> {
    public static final TagManagerFluid INSTANCE = new TagManagerFluid();

    private TagManagerFluid() {
    }

    @Override
    @Nonnull
    public Class<Fluid> getElementClass() {
        return Fluid.class;
    }

    @Override
    public String getTagFolder() {
        return "fluids";
    }

    @Override
    public List<MCTag<Fluid>> getAllTagsFor(Fluid element) {
        return this.getTagCollection().func_199913_a((Object)element).stream().map(location -> new MCTag<Fluid>((ResourceLocation)location, this)).collect(Collectors.toList());
    }

    @Override
    public void addElements(MCTag<Fluid> to, List<Fluid> toAdd) {
        ITag<Fluid> internal = this.getInternal(to);
        if (internal == null) {
            Tag tagFromContents = new Tag((Set)Sets.newHashSet(toAdd), Fluid.class);
            CraftTweakerAPI.apply(new ActionTagCreate<Fluid>(this.getTagCollection(), (ITag<Fluid>)tagFromContents, to));
        } else {
            CraftTweakerAPI.apply(new ActionTagAdd<Fluid>(internal, toAdd, to));
        }
    }

    @Override
    public void removeElements(MCTag<Fluid> from, List<Fluid> toRemove) {
        ITag<Fluid> internal = this.getInternal(from);
        CraftTweakerAPI.apply(new ActionTagRemove<Fluid>(internal, toRemove, from));
    }

    @Override
    public List<Fluid> getElementsInTag(MCTag<Fluid> theTag) {
        ITag<Fluid> internal = this.getInternal(theTag);
        if (internal == null) {
            return Collections.emptyList();
        }
        return internal.func_230236_b_();
    }

    @Override
    @Nullable
    public ITag<Fluid> getInternal(MCTag<Fluid> theTag) {
        return (ITag)this.getTagCollection().func_241833_a().get(theTag.getIdInternal());
    }

    @Override
    public ITagCollection<Fluid> getTagCollection() {
        return TagCollectionManager.func_242178_a().func_241837_c();
    }
}

