/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SerializerScript
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<ScriptRecipe> {
    public static final SerializerScript INSTANCE = new SerializerScript();

    public SerializerScript() {
        this.setRegistryName(new ResourceLocation("crafttweaker:scripts"));
    }

    public ScriptRecipe read(ResourceLocation recipeId, JsonObject json) {
        return new ScriptRecipe(recipeId, json.get("fileName").getAsString(), json.get("content").getAsString());
    }

    public ScriptRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        String fileName = buffer.func_218666_n();
        int parts = buffer.func_150792_a();
        StringBuilder script = new StringBuilder();
        while (parts-- > 0) {
            script.append(buffer.func_218666_n());
        }
        return new ScriptRecipe(recipeId, fileName, script.toString());
    }

    public void write(PacketBuffer buffer, ScriptRecipe recipe) {
        String contents = recipe.getContent();
        LinkedList split = Lists.newLinkedList((Iterable)Splitter.fixedLength((int)4095).split((CharSequence)contents));
        buffer.func_180714_a(recipe.getFileName());
        buffer.func_150787_b(split.size());
        split.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
    }
}

