/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.crafttweaker;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.data.StringData;
import com.blamejared.crafttweaker.impl.loot.conditions.CTLootConditionBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.MCLootCondition;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.Gson;
import net.minecraft.loot.LootSerializers;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.crafttweaker.Json")
@Document(value="vanilla/api/loot/conditions/crafttweaker/Json")
public final class JsonLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private static final Gson GSON = LootSerializers.func_237387_b_().disableHtmlEscaping().create();
    private ResourceLocation name;
    private IData json;

    JsonLootConditionTypeBuilder() {
    }

    @ZenCodeType.Method
    public static ILootCondition create(ResourceLocation type, IData json) {
        return CTLootConditionBuilder.makeJson(type, json);
    }

    @ZenCodeType.Method
    public static ILootCondition create(String type, IData json) {
        return CTLootConditionBuilder.makeJson(type, json);
    }

    @ZenCodeType.Method
    public JsonLootConditionTypeBuilder withJson(ResourceLocation type, IData json) {
        this.name = type;
        this.json = json;
        return this;
    }

    @ZenCodeType.Method
    public JsonLootConditionTypeBuilder withJson(String type, IData json) {
        return this.withJson(new ResourceLocation(type), json);
    }

    @Override
    public ILootCondition finish() {
        net.minecraft.loot.conditions.ILootCondition mcCondition;
        IData jsonData = this.json.copyInternal();
        if (!(jsonData instanceof MapData)) {
            throw new IllegalStateException("Json loot condition IData should be a MapData");
        }
        MapData data = (MapData)jsonData;
        String type = this.name.toString();
        IData jsonType = data.getAt("condition");
        if (jsonType != null && !(jsonType instanceof StringData)) {
            throw new IllegalStateException("Json condition type isn't a string: expected '" + type + "', but found '" + jsonType + "'");
        }
        if (jsonType == null) {
            data.put("condition", new StringData(type));
        } else {
            StringData statedType = (StringData)jsonType;
            String storedType = statedType.getInternal().func_150285_a_();
            if (!storedType.equals(type)) {
                throw new IllegalStateException("Unable to override loot condition type: '" + jsonType + "' was given, but we expected '" + type + "'");
            }
        }
        try {
            mcCondition = (net.minecraft.loot.conditions.ILootCondition)GSON.fromJson(data.toJsonString(), net.minecraft.loot.conditions.ILootCondition.class);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("The returned loot condition is not valid", e);
        }
        return new MCLootCondition(mcCondition);
    }
}

