/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.crafttweaker.conflict;

import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.helper.ItemStackHelper;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;

final class DescriptiveFilter
implements Predicate<Map.Entry<ResourceLocation, IRecipe<?>>> {
    private final Predicate<IRecipe<?>> delegate;
    private final String description;

    private DescriptiveFilter(Predicate<IRecipe<?>> delegate, String description) {
        this.delegate = delegate;
        this.description = description;
    }

    static DescriptiveFilter of() {
        return new DescriptiveFilter(it -> true, "");
    }

    static DescriptiveFilter of(IRecipeManager manager) {
        IRecipeType type = manager.getRecipeType();
        return new DescriptiveFilter(it -> it.func_222127_g() == type, " for type " + manager.getCommandString());
    }

    static DescriptiveFilter of(ItemStack stack) {
        return new DescriptiveFilter(it -> ItemStackHelper.areStacksTheSame(it.func_77571_b(), stack), " for output " + ItemStackHelper.getCommandString(stack));
    }

    @Override
    public boolean test(Map.Entry<ResourceLocation, IRecipe<?>> recipe) {
        return this.delegate.test(recipe.getValue());
    }

    String description() {
        return this.description;
    }
}

