/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.crafttweaker;

import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import com.blamejared.crafttweaker.impl.commands.CTItemArgument;
import com.blamejared.crafttweaker.impl.commands.CommandUtilities;
import com.blamejared.crafttweaker.impl.events.CTEventHandler;
import com.blamejared.crafttweaker.impl.network.PacketHandler;
import com.blamejared.crafttweaker.impl.network.messages.MessageOpen;
import com.blamejared.crafttweaker.impl_native.entity.ExpandPlayerEntity;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.util.TriConsumer;

public final class MiscCommands {
    private MiscCommands() {
    }

    public static void registerMiscCommands(TriConsumer<LiteralArgumentBuilder<CommandSource>, String, String> registerCustomCommand) {
        registerCustomCommand.accept((Object)Commands.func_197057_a((String)"copy").then(Commands.func_197056_a((String)"toCopy", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayerEntity entity = ((CommandSource)context.getSource()).func_197035_h();
            CommandUtilities.copy((PlayerEntity)entity, (String)context.getArgument("toCopy", String.class));
            CommandUtilities.send("Copied!", (PlayerEntity)entity);
            return 0;
        })), null, null);
        registerCustomCommand.accept((Object)((LiteralArgumentBuilder)Commands.func_197057_a((String)"give").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"item", (ArgumentType)CTItemArgument.INSTANCE).executes(context -> {
            ExpandPlayerEntity.give((PlayerEntity)((CommandSource)context.getSource()).func_197035_h(), (IItemStack)context.getArgument("item", IItemStack.class));
            return 0;
        })), (Object)"give", (Object)"Gives the player an item using the Bracket handler syntax. You can also apply tags by appending a .withTag() call.");
        CTCommands.registerCommand(CTCommands.playerCommand("reload", "Points people to /reload", (player, stack) -> {
            CommandUtilities.send((ITextComponent)CommandUtilities.run((TextComponent)new StringTextComponent(CommandUtilities.color("CraftTweaker reload has been deprecated! Use the vanilla /reload instead!", TextFormatting.AQUA)), "/reload"), player);
            return 0;
        }));
        CTCommands.registerCommand(CTCommands.playerCommand("discord", "Opens a link to discord", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen("https://discord.blamejared.com"));
            return 0;
        }));
        CTCommands.registerCommand(CTCommands.playerCommand("issues", "Opens a link to the issue tracker", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen("https://github.com/CraftTweaker/CraftTweaker/issues"));
            return 0;
        }));
        CTCommands.registerCommand(CTCommands.playerCommand("patreon", "Opens a link to patreon", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen("https://patreon.com/jaredlll08"));
            return 0;
        }));
        CTCommands.registerCommand(CTCommands.playerCommand("wiki", "Opens a link to the wiki", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen("https://docs.blamejared.com"));
            return 0;
        }));
        CTCommands.registerCommand(CTCommands.playerCommand("ctgui", "Provides info on the state of CTGUI", (player, stack) -> {
            CommandUtilities.send("CT GUI was limiting and very buggy and has since been removed. It is now recommended to learn ZenScript instead - you can browse the wiki for reference (/ct wiki) or ask for help on the Discord server (/ct discord).", player);
            return 0;
        }));
        CTCommands.registerCommand(CTCommands.playerCommand("block_info", "Activates or deactivates the block reader. In block info mode, right-clicking a block will tell you it's name, metadata and Tile Entity data if applicable.", (player, stack) -> {
            if (CTEventHandler.BLOCK_INFO_PLAYERS.contains(player)) {
                CTEventHandler.BLOCK_INFO_PLAYERS.remove(player);
                CommandUtilities.send("Block info mode deactivated", player);
                if (CTEventHandler.BLOCK_INFO_PLAYERS.isEmpty()) {
                    MinecraftForge.EVENT_BUS.unregister((Object)CTEventHandler.ListenBlockInfo.INSTANCE);
                }
            } else {
                if (CTEventHandler.BLOCK_INFO_PLAYERS.isEmpty()) {
                    MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.RightClickBlock.class, (Consumer)CTEventHandler.ListenBlockInfo.INSTANCE);
                }
                CTEventHandler.BLOCK_INFO_PLAYERS.add(player);
                CommandUtilities.send("Block info mode activated. Right-click a block to see its data.", player);
            }
            return 0;
        }));
        CTCommands.registerCommand(CTCommands.playerCommand("entity_info", "Activates or deactivates the entity reader. In entity info mode, right-clicking an entity will tell you it's name and data.", (player, stack) -> {
            if (CTEventHandler.ENTITY_INFO_PLAYERS.contains(player)) {
                CTEventHandler.ENTITY_INFO_PLAYERS.remove(player);
                CommandUtilities.send("Entity info mode deactivated", player);
                if (CTEventHandler.ENTITY_INFO_PLAYERS.isEmpty()) {
                    MinecraftForge.EVENT_BUS.unregister((Object)CTEventHandler.ListenBlockInfo.INSTANCE);
                }
            } else {
                if (CTEventHandler.ENTITY_INFO_PLAYERS.isEmpty()) {
                    MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.EntityInteract.class, (Consumer)CTEventHandler.ListenEntityInfo.INSTANCE);
                }
                CTEventHandler.ENTITY_INFO_PLAYERS.add(player);
                CommandUtilities.send("Entity info mode activated. Right-click an entity to see its data.", player);
            }
            return 0;
        }));
    }
}

