/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.impl.commands.BracketDumperInfo;
import com.blamejared.crafttweaker.impl.commands.CTCommandCollectionEvent;
import com.blamejared.crafttweaker.impl.commands.CTItemArgument;
import com.blamejared.crafttweaker.impl.commands.CTRecipeTypeArgument;
import com.blamejared.crafttweaker.impl.commands.CommandUtilities;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.DumpCommands;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.HandCommands;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.HelpCommand;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.InventoryCommands;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.MiscCommands;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.RecipeCommands;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.ScriptCommands;
import com.blamejared.crafttweaker.impl.commands.crafttweaker.conflict.ConflictCommand;
import com.blamejared.crafttweaker.impl.commands.script_examples.ExamplesCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.util.TriConsumer;

public class CTCommands {
    private static final Map<String, com.blamejared.crafttweaker.impl.commands.CommandImpl> COMMANDS = new TreeMap<String, com.blamejared.crafttweaker.impl.commands.CommandImpl>(String::compareTo);
    public static LiteralArgumentBuilder<CommandSource> root = Commands.func_197057_a((String)"ct");
    public static LiteralArgumentBuilder<CommandSource> rootAlternative = Commands.func_197057_a((String)"crafttweaker");

    public static void initArgumentTypes() {
        ArgumentTypes.func_218136_a((String)"crafttweaker:item_argument", CTItemArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> CTItemArgument.INSTANCE));
        ArgumentTypes.func_218136_a((String)"crafttweaker:recipe_type_argument", CTRecipeTypeArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> CTRecipeTypeArgument.INSTANCE));
    }

    public static void init(CommandDispatcher<CommandSource> dispatcher) {
        ConflictCommand.registerConflictCommands((TriConsumer<LiteralArgumentBuilder<CommandSource>, String, String>)((TriConsumer)CTCommands::registerCustomCommand));
        DumpCommands.registerDumpCommands(() -> COMMANDS);
        ExamplesCommand.register();
        HandCommands.registerHandCommands();
        InventoryCommands.registerInventoryCommands();
        MiscCommands.registerMiscCommands((TriConsumer<LiteralArgumentBuilder<CommandSource>, String, String>)((TriConsumer)CTCommands::registerCustomCommand));
        RecipeCommands.registerRecipeCommands();
        ScriptCommands.registerScriptCommands();
        DumpCommands.registerDumpers();
        MinecraftForge.EVENT_BUS.post((Event)new CTCommandCollectionEvent());
        com.blamejared.crafttweaker.impl.commands.CommandImpl dump = COMMANDS.get("dump");
        for (BracketDumperInfo dumperInfo : CraftTweakerRegistry.getBracketDumpers().values()) {
            String subCommandName = dumperInfo.getSubCommandName();
            if (dump.getChildCommands().containsKey(subCommandName)) {
                CraftTweakerAPI.logWarning("Found both an explicit Dumping command and a BracketDumper annotation for the name ' %s '. This is a (non-fatal) mod issue!", subCommandName);
                continue;
            }
            CTCommands.registerDump(subCommandName, dumperInfo.getDescription(), dumperInfo);
        }
        HelpCommand.registerHelpCommand(() -> COMMANDS, CTCommands::registerCustomCommand);
        COMMANDS.forEach((s, command) -> CTCommands.registerCommandInternal(root, command));
        COMMANDS.forEach((s, command) -> CTCommands.registerCommandInternal(rootAlternative, command));
        LiteralCommandNode rootNode = dispatcher.register(root);
        LiteralCommandNode rootAltNode = dispatcher.register(rootAlternative);
    }

    public static com.blamejared.crafttweaker.impl.commands.CommandImpl command(String name, String desc, com.blamejared.crafttweaker.impl.commands.CommandCaller caller) {
        return new com.blamejared.crafttweaker.impl.commands.CommandImpl(name, desc, caller);
    }

    public static com.blamejared.crafttweaker.impl.commands.CommandImpl playerCommand(String name, String desc, com.blamejared.crafttweaker.impl.commands.CommandCallerPlayer playerCaller) {
        return CTCommands.command(name, desc, playerCaller);
    }

    public static void registerPlayerDump(String name, String desc, com.blamejared.crafttweaker.impl.commands.CommandCallerPlayer playerCaller) {
        CTCommands.registerDump(name, desc, playerCaller);
    }

    public static void registerDump(String name, String desc, com.blamejared.crafttweaker.impl.commands.CommandCaller caller) {
        CTCommands.registerCommand("dump", new com.blamejared.crafttweaker.impl.commands.CommandImpl(name, desc, caller));
    }

    public static void registerCommand(com.blamejared.crafttweaker.impl.commands.CommandImpl command) {
        COMMANDS.put(command.getName(), command);
    }

    public static void registerCommand(String command, com.blamejared.crafttweaker.impl.commands.CommandImpl subCommand) {
        COMMANDS.get(command).getChildCommands().put(subCommand.getName(), subCommand);
    }

    public static void registerCommand(com.blamejared.crafttweaker.impl.commands.CommandImpl command, com.blamejared.crafttweaker.impl.commands.CommandImpl subCommand) {
        command.getChildCommands().put(subCommand.getName(), subCommand);
    }

    private static void registerCommandInternal(LiteralArgumentBuilder<CommandSource> root, com.blamejared.crafttweaker.impl.commands.CommandImpl command) {
        if (command.getCaller() == null) {
            return;
        }
        LiteralArgumentBuilder literalCommand = Commands.func_197057_a((String)command.getName());
        Map<String, com.blamejared.crafttweaker.impl.commands.CommandImpl> subCommands = command.getChildCommands();
        if (!subCommands.isEmpty()) {
            subCommands.forEach((name, subCommand) -> CTCommands.registerCommandInternal((LiteralArgumentBuilder<CommandSource>)literalCommand, subCommand));
        }
        root.then(literalCommand.executes(command.getCaller()::executeCommand));
    }

    private static void registerCustomCommand(LiteralArgumentBuilder<CommandSource> literal) {
        root.then(literal);
        rootAlternative.then(literal);
    }

    private static void registerCustomCommand(LiteralArgumentBuilder<CommandSource> literal, String name, String description) {
        CTCommands.registerCustomCommand(literal);
        if (name != null && description != null) {
            COMMANDS.put(name, new CommandImpl(name, description, null));
        }
    }

    @Deprecated
    private static void send(ITextComponent component, CommandSource source) {
        CommandUtilities.send(component, source);
    }

    @Deprecated
    static void send(ITextComponent component, PlayerEntity player) {
        CommandUtilities.send(component, player);
    }

    @Deprecated
    static String color(String str, TextFormatting formatting) {
        return CommandUtilities.color(str, formatting);
    }

    @Deprecated
    private static String stripNewLine(String string) {
        return CommandUtilities.stripNewLine(string);
    }

    @Deprecated
    private static String stripNewLine(StringBuilder string) {
        return CommandUtilities.stripNewLine(string);
    }

    @Deprecated
    public static ITextComponent copy(TextComponent base, String toCopy) {
        return CommandUtilities.copy(base, toCopy);
    }

    @Deprecated
    public static ITextComponent open(TextComponent base, String path) {
        return CommandUtilities.open(base, path);
    }

    @Deprecated
    public static TextComponent run(TextComponent base, String command) {
        return CommandUtilities.run(base, command);
    }

    @Deprecated
    public static void registerDump(String name, String desc, CommandCaller caller) {
        CTCommands.registerDump(name, desc, (com.blamejared.crafttweaker.impl.commands.CommandCaller)caller);
    }

    @Deprecated
    public static void registerCommand(CommandImpl command) {
        CTCommands.registerCommand((com.blamejared.crafttweaker.impl.commands.CommandImpl)command);
    }

    @Deprecated
    public static void registerCommand(String command, CommandImpl subCommand) {
        CTCommands.registerCommand(command, (com.blamejared.crafttweaker.impl.commands.CommandImpl)subCommand);
    }

    @Deprecated
    public static void registerCommand(CommandImpl command, CommandImpl subCommand) {
        CTCommands.registerCommand((com.blamejared.crafttweaker.impl.commands.CommandImpl)command, (com.blamejared.crafttweaker.impl.commands.CommandImpl)subCommand);
    }

    @Deprecated
    public static class CommandImpl
    extends com.blamejared.crafttweaker.impl.commands.CommandImpl {
        @Deprecated
        public CommandImpl(String name, String description, CommandCaller caller) {
            super(name, description, caller);
        }

        @Override
        @Deprecated
        public CommandCaller getCaller() {
            com.blamejared.crafttweaker.impl.commands.CommandCaller caller = super.getCaller();
            return caller == null || caller instanceof CommandCaller ? (CommandCaller)caller : caller::executeCommand;
        }

        @Deprecated
        public void registerSubCommand(CommandImpl subCommand) {
            super.registerSubCommand(subCommand);
        }

        @Deprecated
        public Map<String, CommandImpl> getSubCommands() {
            return super.getChildCommands().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> this.safeCast((com.blamejared.crafttweaker.impl.commands.CommandImpl)it.getValue())));
        }

        private CommandImpl safeCast(com.blamejared.crafttweaker.impl.commands.CommandImpl other) {
            return other instanceof CommandImpl ? (CommandImpl)other : new CommandImpl(other.getName(), other.getDescription(), other.getCaller()::executeCommand);
        }
    }

    @Deprecated
    public static interface CommandCallerPlayer
    extends com.blamejared.crafttweaker.impl.commands.CommandCallerPlayer,
    CommandCaller {
    }

    @Deprecated
    public static interface CommandCaller
    extends com.blamejared.crafttweaker.impl.commands.CommandCaller {
    }
}

