/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.villagers;

import com.blamejared.crafttweaker.impl.actions.villagers.ActionTradeBase;
import java.util.List;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraftforge.common.BasicTrade;

public class ActionAddTrade
extends ActionTradeBase {
    private final BasicTrade trade;

    public ActionAddTrade(VillagerProfession profession, int level, BasicTrade trade) {
        super(profession, level);
        this.trade = trade;
    }

    @Override
    public void apply() {
        List<VillagerTrades.ITrade> tradeList = this.getTradeList();
        this.apply(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void apply(List<VillagerTrades.ITrade> tradeList) {
        tradeList.add((VillagerTrades.ITrade)this.trade);
    }

    @Override
    public String describe() {
        return String.format("Adding Villager trade for Profession: '%s' and Level: '%s'", this.profession.toString(), this.level);
    }

    @Override
    public void undo() {
        List<VillagerTrades.ITrade> tradeList = this.getTradeList();
        this.undo(tradeList);
        this.setTradeList(tradeList);
    }

    @Override
    public void undo(List<VillagerTrades.ITrade> tradeList) {
        tradeList.remove(this.trade);
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing addition of Villager trade for Profession: '%s' and Level: '%s'", this.profession.toString(), this.level);
    }
}

