/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.logger.LogLevel;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class ActionBrewingBase
implements IUndoableAction {
    protected final List<IBrewingRecipe> recipes;
    private Field reagentField;

    protected ActionBrewingBase(List<IBrewingRecipe> recipes) {
        this.recipes = recipes;
        try {
            Class<?> mixPredicate = Class.forName("net.minecraft.potion.PotionBrewing$MixPredicate");
            this.reagentField = ObfuscationReflectionHelper.findField(mixPredicate, (String)"field_185199_b");
            this.reagentField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return this.shouldApplySingletons();
    }

    protected Ingredient getItemReagent(PotionBrewing.MixPredicate<Potion> mixInstance) {
        return (Ingredient)this.getFromField(this.reagentField, mixInstance);
    }

    private <T> T getFromField(Field field, Object mixInstance) {
        try {
            return (T)field.get(mixInstance);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            CraftTweakerAPI.logger.throwing(LogLevel.DEBUG, "Could not get Field: ", e);
            return null;
        }
    }
}

