/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import org.apache.logging.log4j.Level;

public class NBTUtil {
    public static CompoundNBT fromText(String json) {
        try {
            return json == null ? null : JsonToNBT.func_180713_a((String)json);
        }
        catch (CommandSyntaxException ex) {
            AdvancedPeripherals.Debug("Could not parse json data to NBT", Level.ERROR);
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toBinary(CompoundNBT nbt) {
        if (nbt == null) {
            return null;
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            try (OutputStream stream = Base64.getEncoder().wrap(outputStream);){
                CompressedStreamTools.func_74799_a((CompoundNBT)nbt, (OutputStream)stream);
            }
            String string = outputStream.toString();
            return string;
        }
        catch (IOException ex) {
            AdvancedPeripherals.Debug("Could not parse NBT data to binary", Level.ERROR);
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompoundNBT fromBinary(String base64) {
        if (base64 == null) {
            return null;
        }
        try (InputStream inputStream = Base64.getDecoder().wrap(new ByteArrayInputStream(base64.getBytes()));){
            CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            return compoundNBT;
        }
        catch (IOException ex) {
            AdvancedPeripherals.Debug("Could not parse binary data to NBT", Level.ERROR);
            ex.printStackTrace();
            return null;
        }
    }
}

