/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.turtles.TurtleChunky;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="advancedperipherals")
public class ChunkManager
implements ForgeChunkManager.LoadingValidationCallback {
    public static final ChunkManager INSTANCE = new ChunkManager();
    private boolean init = true;

    public static void register() {
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"advancedperipherals", (ForgeChunkManager.LoadingValidationCallback)INSTANCE);
    }

    public void validateTickets(ServerWorld world, ForgeChunkManager.TicketHelper ticketHelper) {
        ticketHelper.getBlockTickets().forEach((blockPos, chunks) -> {
            TileEntity tileEntity;
            if (world.func_175625_s(blockPos) != null && (tileEntity = world.func_175625_s(blockPos)) instanceof TileTurtle) {
                TileTurtle tileTurtle = (TileTurtle)tileEntity;
                if (tileTurtle.getUpgrade(TurtleSide.RIGHT) instanceof TurtleChunky || tileTurtle.getUpgrade(TurtleSide.LEFT) instanceof TurtleChunky) {
                    TurtleChunky turtle = (TurtleChunky)(tileTurtle.getUpgrade(TurtleSide.RIGHT) instanceof TurtleChunky ? tileTurtle.getUpgrade(TurtleSide.RIGHT) : tileTurtle.getUpgrade(TurtleSide.LEFT));
                    for (Long chunk : (LongSet)chunks.getSecond()) {
                        turtle.forceChunk(new ChunkPos(chunk.longValue()), true);
                    }
                } else {
                    AdvancedPeripherals.Debug("Trying remove forced chunk " + blockPos);
                    ticketHelper.removeAllTickets(blockPos);
                }
            }
        });
    }

    public void onAboutStart() {
        this.init = true;
    }

    public void onServerStopping() {
        this.init = false;
    }

    @SubscribeEvent
    public static void onServerAboutStart(FMLServerAboutToStartEvent event) {
        INSTANCE.onAboutStart();
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppingEvent event) {
        INSTANCE.onServerStopping();
    }

    public boolean forceChunk(ServerWorld world, BlockPos pos, ChunkPos chunkPos, boolean add) {
        if (this.init) {
            if (add && !add) {
                AdvancedPeripherals.Debug("Trying unforce chunk " + pos);
            }
            return ForgeChunkManager.forceChunk((ServerWorld)world, (String)"advancedperipherals", (BlockPos)pos, (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (boolean)add, (boolean)true);
        }
        return false;
    }
}

