/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.tileentity;

import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeManager;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.capability.NetworkNodeProxyCapability;
import com.refinedmods.refinedstorage.tile.config.IRedstoneConfigurable;
import com.refinedmods.refinedstorage.tile.config.RedstoneMode;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.RsBridgePeripheral;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.setup.TileEntityTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RsBridgeTileEntity
extends PeripheralTileEntity<RsBridgePeripheral>
implements INetworkNodeProxy<RefinedStorageNode>,
IRedstoneConfigurable {
    private final LazyOptional<INetworkNodeProxy<RefinedStorageNode>> networkNodeProxy = LazyOptional.of(() -> this);
    private RefinedStorageNode clientNode;

    public RsBridgeTileEntity() {
        this((TileEntityType)TileEntityTypes.RS_BRIDGE.get());
    }

    public RsBridgeTileEntity(TileEntityType tileType) {
        super(tileType);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction direction) {
        super.getCapability(cap, direction);
        return cap == NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY ? this.networkNodeProxy.cast() : super.getCapability(cap, direction);
    }

    @Override
    protected RsBridgePeripheral createPeripheral() {
        return new RsBridgePeripheral("rsBridge", this);
    }

    public RefinedStorageNode createNode(World world, BlockPos blockPos) {
        return new RefinedStorageNode(world, blockPos);
    }

    @NotNull
    public RefinedStorageNode getNode() {
        if (this.field_145850_b.field_72995_K) {
            if (this.clientNode == null) {
                this.clientNode = this.createNode(this.field_145850_b, this.field_174879_c);
            }
            return this.clientNode;
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager((ServerWorld)this.field_145850_b);
        INetworkNode node = manager.getNode(this.field_174879_c);
        if (node == null) {
            throw new IllegalStateException("No network node present at " + this.field_174879_c.toString() + ", consider removing the block at this position");
        }
        return (RefinedStorageNode)node;
    }

    public void func_145829_t() {
        INetworkNodeManager manager;
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && (manager = API.instance().getNetworkNodeManager((ServerWorld)this.field_145850_b)).getNode(this.field_174879_c) == null) {
            manager.setNode(this.field_174879_c, (INetworkNode)this.createNode(this.field_145850_b, this.field_174879_c));
            manager.markForSaving();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            INetworkNodeManager manager = API.instance().getNetworkNodeManager((ServerWorld)this.field_145850_b);
            INetworkNode node = manager.getNode(this.field_174879_c);
            if (node != null) {
                RefinedStorageNode refinedStorageNode = (RefinedStorageNode)node;
            }
            manager.removeNode(this.field_174879_c);
            manager.markForSaving();
            if (node != null && node.getNetwork() != null) {
                node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, node.getNetwork().getWorld(), node.getNetwork().getPosition());
            }
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.getNode().getRedstoneMode();
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.getNode().setRedstoneMode(mode);
    }
}

