/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.BasePeripheral;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PeripheralTileEntity<T extends BasePeripheral>
extends TileEntity {
    protected T peripheral = this.createPeripheral();
    private LazyOptional<IPeripheral> peripheralCap;

    public PeripheralTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction direction) {
        if (!((BasePeripheral)this.peripheral).isEnabled()) {
            AdvancedPeripherals.Debug(((BasePeripheral)this.peripheral).getType() + " is disabled, enable it in the Configuration.");
        }
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> this.peripheral);
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(cap, direction);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.peripheralCap != null) {
            this.peripheralCap.invalidate();
        }
    }

    protected abstract T createPeripheral();

    public List<IComputerAccess> getConnectedComputers() {
        return ((BasePeripheral)this.peripheral).getConnectedComputers();
    }
}

