/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.IRSAPI;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RefinedStorage {
    private final IRSAPI api = API.instance();

    public RefinedStorage() {
        this.initiate();
    }

    private static INetworkNode read(CompoundNBT tag, NetworkNode node) {
        node.read(tag);
        return node;
    }

    public static List<ItemStack> getItems(INetwork network, boolean craftable) {
        Collection entries = craftable ? network.getItemStorageCache().getCraftablesList().getStacks() : network.getItemStorageCache().getList().getStacks();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
        for (StackListEntry entry : entries) {
            result.add((ItemStack)entry.getStack());
        }
        return result;
    }

    public static List<FluidStack> getFluids(INetwork network, boolean craftable) {
        Collection entries = craftable ? network.getFluidStorageCache().getCraftablesList().getStacks() : network.getFluidStorageCache().getList().getStacks();
        ArrayList<FluidStack> result = new ArrayList<FluidStack>(entries.size());
        for (StackListEntry entry : entries) {
            result.add((FluidStack)entry.getStack());
        }
        return result;
    }

    public static CompoundNBT findMatchingTag(ItemStack stack, String nbtHash, List<ItemStack> items) {
        for (ItemStack rsStack : items) {
            if (rsStack.func_190916_E() <= 0 || !rsStack.func_77973_b().equals(stack.func_77973_b())) continue;
            AdvancedPeripherals.Debug(rsStack + "");
            CompoundNBT tag = rsStack.func_77978_p();
            String hash = NBTUtil.getNBTHash((CompoundNBT)tag);
            AdvancedPeripherals.Debug("HASH: " + hash);
            AdvancedPeripherals.Debug("TAG: " + tag);
            if (!nbtHash.equals(hash)) continue;
            return tag.func_74737_b();
        }
        return null;
    }

    public void initiate() {
        this.api.getNetworkNodeRegistry().add(new ResourceLocation("advancedperipherals", "rs_bridge"), (tag, world, pos) -> RefinedStorage.read(tag, new RefinedStorageNode(world, pos)));
    }

    public IRSAPI getApi() {
        return this.api;
    }
}

