/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.turtles;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.BasePeripheral;
import de.srendi.advancedperipherals.common.blocks.base.TileEntityList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTurtle<T extends BasePeripheral>
extends AbstractTurtleUpgrade {
    protected T peripheral = this.createPeripheral();
    protected TileEntity tileEntity;
    protected int tick;
    protected boolean init;

    public BaseTurtle(String id, String adjective, ItemStack item) {
        super(new ResourceLocation("advancedperipherals", id), TurtleUpgradeType.PERIPHERAL, adjective, item);
    }

    protected abstract T createPeripheral();

    protected abstract ModelResourceLocation getLeftModel();

    protected abstract ModelResourceLocation getRightModel();

    @NotNull
    public TransformedModel getModel(@Nullable ITurtleAccess iTurtleAccess, @NotNull TurtleSide turtleSide) {
        if (this.getLeftModel() == null) {
            float xOffset = turtleSide == TurtleSide.LEFT ? -0.40625f : 0.40625f;
            Matrix4f transform = new Matrix4f(new float[]{0.0f, 0.0f, -1.0f, 1.0f + xOffset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            return TransformedModel.of((ItemStack)this.getCraftingItem(), (TransformationMatrix)new TransformationMatrix(transform));
        }
        return TransformedModel.of((ModelResourceLocation)(turtleSide == TurtleSide.LEFT ? this.getLeftModel() : this.getRightModel()));
    }

    @Nullable
    public IPeripheral createPeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        return this.peripheral;
    }

    public void update(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        if (!this.init && !turtle.getWorld().field_72995_K) {
            World world = turtle.getWorld();
            BlockPos position = turtle.getPosition();
            this.tileEntity = turtle instanceof TurtleBrain ? ((TurtleBrain)turtle).getOwner() : world.func_175625_s(position);
            ((BasePeripheral)this.peripheral).setTileEntity(this.tileEntity);
            this.init = true;
        }
        ++this.tick;
        if (this.tick > 10) {
            TileEntityList tileEntityList = TileEntityList.get(turtle.getWorld());
            if (!tileEntityList.getBlockPositions().contains(turtle.getPosition())) {
                tileEntityList.setTileEntity(turtle.getWorld(), turtle.getPosition());
            }
            this.tick = 0;
        }
    }
}

