/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.Action;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.BasePeripheral;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorage;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorageNode;
import de.srendi.advancedperipherals.common.blocks.tileentity.RsBridgeTileEntity;
import de.srendi.advancedperipherals.common.configuration.AdvancedPeripheralsConfig;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RsBridgePeripheral
extends BasePeripheral {
    private final RsBridgeTileEntity tileEntity;

    public RsBridgePeripheral(String type, RsBridgeTileEntity tileEntity) {
        super(type, tileEntity);
        this.tileEntity = tileEntity;
    }

    private RefinedStorageNode getNode() {
        return this.tileEntity.getNode();
    }

    private INetwork getNetwork() {
        return this.getNode().getNetwork();
    }

    @Override
    public boolean isEnabled() {
        return AdvancedPeripheralsConfig.enableRsBridge;
    }

    @LuaFunction(mainThread=true)
    public final Object[] listItems() {
        HashMap items = new HashMap();
        int i = 1;
        for (ItemStack stack : RefinedStorage.getItems(this.getNetwork(), false)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            CompoundNBT nbt = stack.func_77978_p();
            Set tags = stack.func_77973_b().getTags();
            map.put("name", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString());
            map.put("amount", stack.func_190916_E());
            map.put("displayName", stack.func_200301_q().getString());
            if (nbt != null && !nbt.isEmpty()) {
                map.put("nbt", nbt.toString());
            }
            if (!tags.isEmpty()) {
                map.put("tags", tags);
            }
            items.put(i, map);
            ++i;
        }
        return new Object[]{items};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listCraftableItems() {
        HashMap items = new HashMap();
        int i = 1;
        for (ItemStack stack : RefinedStorage.getItems(this.getNetwork(), true)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            CompoundNBT nbt = stack.func_77978_p();
            Set tags = stack.func_77973_b().getTags();
            map.put("name", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString());
            map.put("craftamount", stack.func_190916_E());
            for (ItemStack oStack : RefinedStorage.getItems(this.getNetwork(), false)) {
                if (oStack.func_77969_a(stack)) {
                    map.put("amount", oStack.func_190916_E());
                    break;
                }
                map.put("amount", 0);
            }
            map.put("displayName", stack.func_200301_q().getString());
            if (nbt != null && !nbt.isEmpty()) {
                map.put("nbt", nbt.toString());
            }
            if (!tags.isEmpty()) {
                map.put("tags", tags);
            }
            items.put(i, map);
            ++i;
        }
        return new Object[]{items};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listFluids() {
        HashMap items = new HashMap();
        int i = 1;
        for (FluidStack stack : RefinedStorage.getFluids(this.getNetwork(), false)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Set tags = stack.getFluid().getTags();
            map.put("name", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)stack.getFluid()).toString());
            map.put("amount", stack.getAmount());
            map.put("displayName", stack.getDisplayName().getString());
            if (!tags.isEmpty()) {
                map.put("tags", tags);
            }
            items.put(i, map);
            ++i;
        }
        return new Object[]{items};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listCraftableFluids() {
        HashMap items = new HashMap();
        int i = 1;
        for (FluidStack stack : RefinedStorage.getFluids(this.getNetwork(), true)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Set tags = stack.getFluid().getTags();
            map.put("name", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)stack.getFluid()).toString());
            map.put("craftamount", stack.getAmount());
            for (FluidStack oStack : RefinedStorage.getFluids(this.getNetwork(), false)) {
                if (oStack.isFluidEqual(stack)) {
                    map.put("amount", oStack.getAmount());
                    break;
                }
                map.put("amount", 0);
            }
            map.put("displayName", stack.getDisplayName().getString());
            if (!tags.isEmpty()) {
                map.put("tags", tags);
            }
            items.put(i, map);
            ++i;
        }
        return new Object[]{items};
    }

    @LuaFunction(mainThread=true)
    public final int getEnergyUsage() {
        return this.getNetwork().getEnergyUsage();
    }

    @LuaFunction(mainThread=true)
    public final int getMaxEnergyStorage() {
        return this.getNetwork().getEnergyStorage().getMaxEnergyStored();
    }

    @LuaFunction(mainThread=true)
    public final int getEnergyStorage() {
        return this.getNetwork().getEnergyStorage().getEnergyStored();
    }

    @LuaFunction(mainThread=true)
    public final int exportItem(IArguments arguments) throws LuaException {
        IItemHandler inventory;
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork(), false));
        Direction direction = Direction.valueOf((String)arguments.getString(1).toUpperCase(Locale.ROOT));
        TileEntity targetEntity = this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v().func_177972_a(direction));
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory at " + arguments.getString(1));
        }
        ItemStack extracted = this.getNetwork().extractItem(stack, stack.func_190916_E(), Action.SIMULATE);
        if (extracted.func_190926_b()) {
            return 0;
        }
        int transferableAmount = extracted.func_190916_E();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted, (boolean)true);
        if (!remaining.func_190926_b()) {
            transferableAmount -= remaining.func_190916_E();
        }
        if (!(remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)(extracted = this.getNetwork().extractItem(stack, transferableAmount, Action.PERFORM)), (boolean)false)).func_190926_b()) {
            this.getNetwork().insertItem(remaining, remaining.func_190916_E(), Action.PERFORM);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int importItem(IArguments arguments) throws LuaException {
        IItemHandler inventory;
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork(), false));
        Direction direction = Direction.valueOf((String)arguments.getString(1).toUpperCase(Locale.ROOT));
        int count = stack.func_190916_E();
        TileEntity targetEntity = this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v().func_177972_a(direction));
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory at " + arguments.getString(1));
        }
        int amount = count;
        int transferableAmount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).func_77969_a(stack)) continue;
            if (inventory.getStackInSlot(i).func_190916_E() >= amount) {
                transferableAmount += amount;
                this.getNetwork().insertItem(stack, amount, Action.PERFORM);
                inventory.extractItem(i, amount, false);
                break;
            }
            amount = count - inventory.getStackInSlot(i).func_190916_E();
            transferableAmount += inventory.getStackInSlot(i).func_190916_E();
            this.getNetwork().insertItem(stack, inventory.getStackInSlot(i).func_190916_E(), Action.PERFORM);
            inventory.extractItem(i, inventory.getStackInSlot(i).func_190916_E(), false);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int exportItemToChest(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory;
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork(), false));
        IPeripheral chest = computer.getAvailablePeripheral(arguments.getString(1));
        if (chest == null) {
            throw new LuaException("No valid chest for " + arguments.getString(1));
        }
        TileEntity targetEntity = (TileEntity)chest.getTarget();
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory for " + arguments.getString(1));
        }
        ItemStack extracted = this.getNetwork().extractItem(stack, stack.func_190916_E(), Action.SIMULATE);
        if (extracted.func_190926_b()) {
            return 0;
        }
        int transferableAmount = extracted.func_190916_E();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted, (boolean)true);
        if (!remaining.func_190926_b()) {
            transferableAmount -= remaining.func_190916_E();
        }
        if (!(remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)(extracted = this.getNetwork().extractItem(stack, transferableAmount, Action.PERFORM)), (boolean)false)).func_190926_b()) {
            this.getNetwork().insertItem(remaining, remaining.func_190916_E(), Action.PERFORM);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int importItemFromChest(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory;
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork(), false));
        IPeripheral chest = computer.getAvailablePeripheral(arguments.getString(1));
        int count = stack.func_190916_E();
        if (chest == null) {
            throw new LuaException("No valid chest for " + arguments.getString(1));
        }
        TileEntity targetEntity = (TileEntity)chest.getTarget();
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory for " + arguments.getString(1));
        }
        int amount = count;
        int transferableAmount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).func_77969_a(stack)) continue;
            if (inventory.getStackInSlot(i).func_190916_E() >= amount) {
                transferableAmount += amount;
                this.getNetwork().insertItem(stack, amount, Action.PERFORM);
                inventory.extractItem(i, amount, false);
                break;
            }
            amount = count - inventory.getStackInSlot(i).func_190916_E();
            transferableAmount += inventory.getStackInSlot(i).func_190916_E();
            this.getNetwork().insertItem(stack, inventory.getStackInSlot(i).func_190916_E(), Action.PERFORM);
            inventory.extractItem(i, inventory.getStackInSlot(i).func_190916_E(), false);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final boolean craftItem(IArguments arguments) throws LuaException {
        ItemStack stack = ItemUtil.getItemStackRS(arguments.getTable(0), RefinedStorage.getItems(this.getNetwork(), true));
        if (stack == null) {
            throw new LuaException("The item " + arguments.getTable(0).get("name") + "is not craftable");
        }
        ICalculationResult result = this.getNetwork().getCraftingManager().create(stack, stack.func_190916_E());
        CalculationResultType type = result.getType();
        if (result.getType() == CalculationResultType.OK) {
            this.getNetwork().getCraftingManager().start(result.getTask());
        }
        return type == CalculationResultType.OK;
    }

    @LuaFunction(mainThread=true)
    public final boolean craftFluid(String fluid, int count) {
        ICalculationResult result = this.getNetwork().getCraftingManager().create(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)), 0), count);
        CalculationResultType type = result.getType();
        if (result.getType() == CalculationResultType.OK) {
            this.getNetwork().getCraftingManager().start(result.getTask());
        }
        return type == CalculationResultType.OK;
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCrafting(String item) {
        ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)));
        for (ICraftingTask task : this.getNetwork().getCraftingManager().getTasks()) {
            ItemStack taskStack = task.getRequested().getItem();
            if (!taskStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }
}

