/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.BasePeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.AdvancedPeripheralsConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerDetectorPeripheral
extends BasePeripheral {
    public PlayerDetectorPeripheral(String type, PeripheralTileEntity<?> tileEntity) {
        super(type, tileEntity);
    }

    public PlayerDetectorPeripheral(String type, TileEntity tileEntity) {
        super(type, tileEntity);
    }

    @Override
    public boolean isEnabled() {
        return AdvancedPeripheralsConfig.enablePlayerDetector;
    }

    @LuaFunction(mainThread=true)
    public final List<String> getPlayersInRange(int range) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!this.isInRange(this.tileEntity.func_174877_v(), (PlayerEntity)player, range)) continue;
            playersName.add(player.func_200200_C_().getString());
        }
        return playersName;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayersInRange(int range) {
        if (this.getPlayers().isEmpty()) {
            return false;
        }
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!this.isInRange(this.tileEntity.func_174877_v(), (PlayerEntity)player, range)) continue;
            return true;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final boolean isPlayerInRange(int range, String username) {
        ArrayList<String> playersName = new ArrayList<String>();
        for (PlayerEntity playerEntity : this.getPlayers()) {
            if (!this.isInRange(this.tileEntity.func_174877_v(), playerEntity, range)) continue;
            playersName.add(playerEntity.func_200200_C_().getString());
        }
        return playersName.contains(username);
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Double> getPlayerPos(String username) {
        ServerPlayerEntity existingPlayer = null;
        for (ServerPlayerEntity player : this.getPlayers()) {
            if (!player.func_200200_C_().getString().equals(username)) continue;
            existingPlayer = player;
            break;
        }
        if (existingPlayer == null) {
            return null;
        }
        HashMap<String, Double> coordinates = new HashMap<String, Double>();
        coordinates.put("x", Math.floor(existingPlayer.func_226277_ct_()));
        coordinates.put("y", Math.floor(existingPlayer.func_226278_cu_()));
        coordinates.put("z", Math.floor(existingPlayer.func_226281_cx_()));
        return coordinates;
    }

    private List<ServerPlayerEntity> getPlayers() {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
    }

    private boolean isInRange(BlockPos pos, PlayerEntity player, int range) {
        BlockPos pos1 = new BlockPos(pos.func_177958_n() - range, pos.func_177956_o() + range, pos.func_177952_p() + range);
        BlockPos pos2 = new BlockPos(pos.func_177958_n() + range, pos.func_177956_o() - range, pos.func_177952_p() - range);
        int x1 = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
        int y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        int z1 = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
        int x2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
        int y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
        int z2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
        int x = player.func_233580_cy_().func_177958_n();
        int z = player.func_233580_cy_().func_177952_p();
        int y = player.func_233580_cy_().func_177956_o();
        return x >= x1 && x <= x2 && y >= y1 && y <= y2 && z >= z1 && z <= z2;
    }
}

