/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import com.google.common.collect.UnmodifiableIterator;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.CraftJob;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.BasePeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.AdvancedPeripheralsConfig;
import de.srendi.advancedperipherals.common.util.ItemUtil;
import de.srendi.advancedperipherals.common.util.ServerWorker;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MeBridgePeripheral
extends BasePeripheral {
    private IGridNode node;
    private IActionSource source;

    public MeBridgePeripheral(String type, IActionSource source, PeripheralTileEntity<?> tileEntity) {
        super(type, tileEntity);
        this.source = source;
    }

    public void setNode(IGridNode node) {
        this.node = node;
    }

    @Override
    public boolean isEnabled() {
        return AdvancedPeripheralsConfig.enableMeBridge;
    }

    @LuaFunction(mainThread=false)
    public final MethodResult craftItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack itemToCraft = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        if (itemToCraft.func_190926_b()) {
            throw new NullPointerException("Item " + itemToCraft + " does not exists");
        }
        CraftJob job = new CraftJob(this.tileEntity.func_145831_w(), computer, this.node, arguments.getString(1), Optional.of(itemToCraft.func_190916_E()), this.source);
        ServerWorker.add(job::startCrafting);
        return MethodResult.pullEvent((String)"crafting", (ILuaCallback)job);
    }

    @LuaFunction(mainThread=true)
    public final double getEnergyUsage() {
        return ((IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class)).getAvgPowerUsage();
    }

    @LuaFunction(mainThread=true)
    public final double getEnergyStorage() {
        return ((IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class)).getStoredPower();
    }

    @LuaFunction(mainThread=true)
    public final double getMaxEnergyStorage() {
        return ((IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class)).getMaxStoredPower();
    }

    @LuaFunction(mainThread=true)
    public final boolean isItemCrafting(IArguments arguments) throws LuaException {
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ICraftingGrid grid = (ICraftingGrid)this.node.getGrid().getCache(ICraftingGrid.class);
        return grid.isRequesting(AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor)));
    }

    @LuaFunction(mainThread=true)
    public final int exportItem(IArguments arguments) throws LuaException {
        IItemHandler inventory;
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        IAEItemStack aeStack = AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, stack);
        if (aeStack == null) {
            throw new LuaException("Item " + stack + " does not exists in the ME system or the system is offline");
        }
        Direction direction = Direction.valueOf((String)arguments.getString(1).toUpperCase(Locale.ROOT));
        TileEntity targetEntity = this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v().func_177972_a(direction));
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory at " + direction);
        }
        aeStack.setStackSize((long)stack.func_190916_E());
        IAEItemStack extracted = (IAEItemStack)monitor.extractItems((IAEStack)aeStack, Actionable.SIMULATE, this.source);
        if (extracted == null) {
            throw new LuaException("Item " + stack + " does not exists in the ME system or the system is offline");
        }
        int transferableAmount = (int)extracted.getStackSize();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted.createItemStack(), (boolean)true);
        if (!remaining.func_190926_b()) {
            transferableAmount -= remaining.func_190916_E();
        }
        aeStack.setStackSize((long)transferableAmount);
        extracted = (IAEItemStack)monitor.extractItems((IAEStack)aeStack, Actionable.MODULATE, this.source);
        remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted.createItemStack(), (boolean)false);
        if (!remaining.func_190926_b()) {
            aeStack.setStackSize((long)remaining.func_190916_E());
            monitor.injectItems((IAEStack)aeStack, Actionable.MODULATE, this.source);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int importItem(IArguments arguments) throws LuaException {
        IItemHandler inventory;
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        int count = stack.func_190916_E();
        stack.func_190920_e(count);
        IAEItemStack aeStack = AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, stack);
        if (aeStack == null) {
            throw new LuaException("Item " + stack + " does not exists in the ME system or the system is offline");
        }
        Direction direction = Direction.valueOf((String)arguments.getString(1).toUpperCase(Locale.ROOT));
        TileEntity targetEntity = this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v().func_177972_a(direction));
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory at " + direction);
        }
        aeStack.setStackSize((long)count);
        int amount = count;
        int transferableAmount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).func_77969_a(stack)) continue;
            if (inventory.getStackInSlot(i).func_190916_E() >= amount) {
                transferableAmount += amount;
                aeStack.setStackSize((long)amount);
                monitor.injectItems((IAEStack)aeStack, Actionable.MODULATE, this.source);
                inventory.extractItem(i, amount, false);
                break;
            }
            amount = count - inventory.getStackInSlot(i).func_190916_E();
            transferableAmount += inventory.getStackInSlot(i).func_190916_E();
            aeStack.setStackSize((long)inventory.getStackInSlot(i).func_190916_E());
            monitor.injectItems((IAEStack)aeStack, Actionable.MODULATE, this.source);
            inventory.extractItem(i, inventory.getStackInSlot(i).func_190916_E(), false);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int exportItemToChest(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory;
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        IAEItemStack aeStack = AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, stack);
        if (aeStack == null) {
            throw new LuaException("Item " + stack + " does not exists in the ME system or the system is offline");
        }
        IPeripheral chest = computer.getAvailablePeripheral(arguments.getString(1));
        if (chest == null) {
            throw new LuaException("No valid chest for " + arguments.getString(1));
        }
        TileEntity targetEntity = (TileEntity)chest.getTarget();
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory for " + arguments.getString(1));
        }
        aeStack.setStackSize((long)stack.func_190916_E());
        IAEItemStack extracted = (IAEItemStack)monitor.extractItems((IAEStack)aeStack, Actionable.SIMULATE, this.source);
        if (extracted == null) {
            throw new LuaException("Item " + stack + " does not exists in the ME system or the system is offline");
        }
        int transferableAmount = (int)extracted.getStackSize();
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted.createItemStack(), (boolean)true);
        if (!remaining.func_190926_b()) {
            transferableAmount -= remaining.func_190916_E();
        }
        aeStack.setStackSize((long)transferableAmount);
        extracted = (IAEItemStack)monitor.extractItems((IAEStack)aeStack, Actionable.MODULATE, this.source);
        remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)extracted.createItemStack(), (boolean)false);
        if (!remaining.func_190926_b()) {
            aeStack.setStackSize((long)remaining.func_190916_E());
            monitor.injectItems((IAEStack)aeStack, Actionable.MODULATE, this.source);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final int importItemFromChest(IComputerAccess computer, IArguments arguments) throws LuaException {
        IItemHandler inventory;
        IMEMonitor monitor = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack stack = ItemUtil.getItemStack(arguments.getTable(0), (IMEMonitor<IAEItemStack>)monitor);
        int count = stack.func_190916_E();
        stack.func_190920_e(count);
        IAEItemStack aeStack = AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, stack);
        if (aeStack == null) {
            throw new LuaException("Item " + stack + " does not exists in the ME system or the system is offline");
        }
        IPeripheral chest = computer.getAvailablePeripheral(arguments.getString(1));
        if (chest == null) {
            throw new LuaException("Peripheral not found" + arguments.getString(1));
        }
        TileEntity targetEntity = (TileEntity)chest.getTarget();
        IItemHandler iItemHandler = inventory = targetEntity != null ? (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().orElse(null) : null;
        if (inventory == null) {
            throw new LuaException("No valid inventory for " + arguments.getString(1));
        }
        aeStack.setStackSize((long)count);
        int amount = count;
        int transferableAmount = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).func_77969_a(stack)) continue;
            if (inventory.getStackInSlot(i).func_190916_E() >= amount) {
                transferableAmount += amount;
                aeStack.setStackSize((long)amount);
                monitor.injectItems((IAEStack)aeStack, Actionable.MODULATE, this.source);
                inventory.extractItem(i, amount, false);
                break;
            }
            amount = count - inventory.getStackInSlot(i).func_190916_E();
            transferableAmount += inventory.getStackInSlot(i).func_190916_E();
            aeStack.setStackSize((long)inventory.getStackInSlot(i).func_190916_E());
            monitor.injectItems((IAEStack)aeStack, Actionable.MODULATE, this.source);
            inventory.extractItem(i, inventory.getStackInSlot(i).func_190916_E(), false);
        }
        return transferableAmount;
    }

    @LuaFunction(mainThread=true)
    public final Object[] listItems() {
        IMEMonitor inventory = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        return new Object[]{AppEngApi.INSTANCE.iteratorToMapStack(inventory.getStorageList().iterator(), 0)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listCraftableItems() {
        IMEMonitor inventory = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        return new Object[]{AppEngApi.INSTANCE.iteratorToMapStack(inventory.getStorageList().iterator(), 2)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listFluid() {
        IMEMonitor inventory = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IFluidStorageChannel.class));
        return new Object[]{AppEngApi.INSTANCE.iteratorToMapFluid(inventory.getStorageList().iterator(), 0)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] listCraftableFluid() {
        IMEMonitor inventory = ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IFluidStorageChannel.class));
        return new Object[]{AppEngApi.INSTANCE.iteratorToMapFluid(inventory.getStorageList().iterator(), 2)};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getCraftingCPUs() throws LuaException {
        ICraftingGrid grid = (ICraftingGrid)this.node.getGrid().getCache(ICraftingGrid.class);
        if (grid == null) {
            throw new LuaException("Not connected");
        }
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        UnmodifiableIterator iterator = grid.getCpus().iterator();
        if (!iterator.hasNext()) {
            throw new LuaException("The system has no crafting cpus");
        }
        int i = 1;
        while (iterator.hasNext()) {
            Object o = AppEngApi.INSTANCE.getObjectFromCPU((ICraftingCPU)iterator.next());
            if (o == null) continue;
            map.put(i++, o);
        }
        return new Object[]{map};
    }
}

