/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.BasePeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.AdvancedPeripheralsConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class EnvironmentDetectorPeripheral
extends BasePeripheral {
    public EnvironmentDetectorPeripheral(String type, PeripheralTileEntity<?> tileEntity) {
        super(type, tileEntity);
    }

    public EnvironmentDetectorPeripheral(String type, TileEntity tileEntity) {
        super(type, tileEntity);
    }

    @Override
    public boolean isEnabled() {
        return AdvancedPeripheralsConfig.enableEnvironmentDetector;
    }

    @LuaFunction(mainThread=true)
    public final String getBiome() {
        String biomeName = this.tileEntity.func_145831_w().func_226691_t_(this.tileEntity.func_174877_v()).getRegistryName().toString();
        String[] biome = biomeName.split(":");
        return biome[1];
    }

    @LuaFunction(mainThread=true)
    public final int getSkyLightLevel() {
        return this.tileEntity.func_145831_w().func_226658_a_(LightType.SKY, this.tileEntity.func_174877_v().func_177982_a(0, 1, 0));
    }

    @LuaFunction(mainThread=true)
    public final int getBlockLightLevel() {
        return this.tileEntity.func_145831_w().func_226658_a_(LightType.BLOCK, this.tileEntity.func_174877_v().func_177982_a(0, 1, 0));
    }

    @LuaFunction(mainThread=true)
    public final int getDayLightLevel() {
        World world = this.tileEntity.func_145831_w();
        int i = world.func_226658_a_(LightType.SKY, this.tileEntity.func_174877_v().func_177982_a(0, 1, 0)) - world.func_175657_ab();
        float f = world.func_72929_e(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * MathHelper.func_76134_b((float)f));
        }
        i = MathHelper.func_76125_a((int)i, (int)0, (int)15);
        return i;
    }

    @LuaFunction(mainThread=true)
    public final long getTime() {
        return this.tileEntity.func_145831_w().func_72820_D();
    }

    @LuaFunction(mainThread=true)
    public final boolean isSlimeChunk() {
        ChunkPos chunkPos = new ChunkPos(this.tileEntity.func_174877_v());
        return SharedSeedRandom.func_205190_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (long)((ISeedReader)this.tileEntity.func_145831_w()).func_72905_C(), (long)987234911L).nextInt(10) == 0;
    }

    @LuaFunction(mainThread=true)
    public final String getDimensionProvider() {
        return this.tileEntity.func_145831_w().func_234923_W_().func_240901_a_().func_110624_b();
    }

    @LuaFunction(mainThread=true)
    public final String getDimensionName() {
        return this.tileEntity.func_145831_w().func_234923_W_().func_240901_a_().func_110623_a();
    }

    @LuaFunction(mainThread=true)
    public final String getDimensionPaN() {
        return this.tileEntity.func_145831_w().func_234923_W_().func_240901_a_().func_110624_b() + ":" + this.tileEntity.func_145831_w().func_234923_W_().func_240901_a_().func_110623_a();
    }

    @LuaFunction(mainThread=true)
    public final boolean isDimension(String dimension) {
        return this.tileEntity.func_145831_w().func_234923_W_().func_240901_a_().func_110623_a().equals(dimension);
    }

    @LuaFunction(mainThread=true)
    public final Set<String> listDimensions() {
        HashSet<String> dimensions = new HashSet<String>();
        ServerLifecycleHooks.getCurrentServer().func_212370_w().forEach(serverWorld -> dimensions.add(serverWorld.func_234923_W_().func_240901_a_().func_110623_a()));
        return dimensions;
    }

    @LuaFunction(mainThread=true)
    public final int getMoonId() {
        return this.getCurrentMoonPhase().keySet().toArray(new Integer[0])[0];
    }

    @LuaFunction(mainThread=true)
    public final String getMoonName() {
        String[] name = this.getCurrentMoonPhase().values().toArray(new String[0]);
        return name[0];
    }

    private Map<Integer, String> getCurrentMoonPhase() {
        HashMap<Integer, String> moon = new HashMap<Integer, String>();
        if (this.tileEntity.func_145831_w().func_234923_W_().func_240901_a_().func_110623_a().equals("overworld")) {
            switch (this.tileEntity.func_145831_w().func_242414_af()) {
                case 0: {
                    moon.put(0, "Full moon");
                    break;
                }
                case 1: {
                    moon.put(1, "Waning gibbous");
                    break;
                }
                case 2: {
                    moon.put(2, "Third quarter");
                    break;
                }
                case 3: {
                    moon.put(3, "Wanning crescent");
                    break;
                }
                case 4: {
                    moon.put(4, "New moon");
                    break;
                }
                case 5: {
                    moon.put(5, "Waxing crescent");
                    break;
                }
                case 6: {
                    moon.put(6, "First quarter");
                    break;
                }
                case 7: {
                    moon.put(7, "Waxing gibbous");
                    break;
                }
                default: {
                    moon.put(0, "What is a moon");
                    break;
                }
            }
        } else {
            moon.put(0, "Moon.exe not found...");
        }
        return moon;
    }

    private HashMap<Integer, String> getMoonPhases() {
        HashMap<Integer, String> moon = new HashMap<Integer, String>();
        moon.put(1, "Waning gibbous");
        moon.put(2, "Third guarter");
        moon.put(3, "Wanning crescent");
        moon.put(4, "New moon");
        moon.put(5, "Waxing crescent");
        moon.put(6, "First quarter");
        moon.put(7, "Waxing gibbous");
        moon.put(8, "Full moon");
        return moon;
    }

    @LuaFunction(mainThread=true)
    public final boolean isRaining() {
        return this.tileEntity.func_145831_w().func_72867_j(0.0f) > 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final boolean isThunder() {
        return this.tileEntity.func_145831_w().func_72819_i(0.0f) > 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final boolean isSunny() {
        return this.tileEntity.func_145831_w().func_72819_i(0.0f) < 1.0f && this.tileEntity.func_145831_w().func_72867_j(0.0f) < 1.0f;
    }
}

