/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.BasePeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.AdvancedPeripheralsConfig;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ChatBoxPeripheral
extends BasePeripheral {
    private int tick;

    public ChatBoxPeripheral(String type, PeripheralTileEntity<?> tileEntity) {
        super(type, tileEntity);
    }

    public ChatBoxPeripheral(String type, TileEntity tileEntity) {
        super(type, tileEntity);
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    @Override
    public boolean isEnabled() {
        return AdvancedPeripheralsConfig.enableChatBox;
    }

    @LuaFunction(mainThread=true)
    public final void sendMessage(Object message) throws LuaException {
        if (this.tick >= AdvancedPeripheralsConfig.chatBoxCooldown) {
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                player.func_145747_a((ITextComponent)new StringTextComponent("" + message), UUID.randomUUID());
            }
        } else {
            throw new LuaException("You are sending messages too often. You can modify the cooldown in the config.");
        }
        this.tick = 0;
    }

    @LuaFunction(mainThread=true)
    public final void sendMessageToPlayer(Object message, String playerName) throws LuaException {
        if (this.tick >= AdvancedPeripheralsConfig.chatBoxCooldown) {
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (!player.func_200200_C_().getString().equals(playerName)) continue;
                player.func_145747_a((ITextComponent)new StringTextComponent("" + message), UUID.randomUUID());
            }
        } else {
            throw new LuaException("You are sending messages too often. You can modify the cooldown in the config.");
        }
        this.tick = 0;
    }
}

