/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePeripheral
implements IPeripheral {
    protected final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    protected String type;
    protected TileEntity tileEntity;

    public BasePeripheral(String type, PeripheralTileEntity<?> tileEntity) {
        this.type = type;
        this.tileEntity = tileEntity;
    }

    public BasePeripheral(String type, TileEntity tileEntity) {
        this.type = type;
        this.tileEntity = tileEntity;
    }

    public void setTileEntity(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public List<IComputerAccess> getConnectedComputers() {
        return this.connectedComputers;
    }

    @Nullable
    public Object getTarget() {
        return this.tileEntity;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public void attach(@NotNull IComputerAccess computer) {
        this.connectedComputers.add(computer);
    }

    public void detach(@NotNull IComputerAccess computer) {
        this.connectedComputers.remove(computer);
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return iPeripheral == this;
    }

    public abstract boolean isEnabled();

    @LuaFunction
    public final String getName() {
        return this.tileEntity.getTileData().func_74779_i("CustomName");
    }
}

