/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.util.ServerWorker;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CraftJob
implements ICraftingCallback,
ILuaCallback {
    public static final String EVENT = "crafting";
    private final IComputerAccess computer;
    private final IGridNode node;
    private final IActionSource source;
    private final String item;
    private final Optional<Integer> count;
    private final World world;
    private MethodResult result;
    private LuaException exception;

    public CraftJob(World world, IComputerAccess computer, IGridNode node, String item, Optional<Integer> count, IActionSource source) {
        this.computer = computer;
        this.node = node;
        this.world = world;
        this.source = source;
        this.item = item;
        this.count = count;
    }

    public void startCrafting() {
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            this.computer.queueEvent(EVENT, new Object[]{null, "not connected"});
            this.result = MethodResult.of((Object[])new Object[]{null, "not connected"});
            this.exception = new LuaException("not connected");
            return;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IMEMonitor monitor = storage.getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ItemStack itemstack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.item)));
        IAEItemStack aeItem = AppEngApi.getInstance().findAEStackFromItemStack((IMEMonitor<IAEItemStack>)monitor, itemstack);
        if (aeItem == null) {
            this.computer.queueEvent(EVENT, new Object[]{null, this.item + " does not exists in the me system"});
            this.result = MethodResult.of((Object[])new Object[]{null, this.item + " does not exists in the me system"});
            this.exception = new LuaException(this.item + " is not craftable");
            return;
        }
        if (!aeItem.isCraftable()) {
            this.computer.queueEvent(EVENT, new Object[]{null, this.item + " is not craftable"});
            this.result = MethodResult.of((Object[])new Object[]{null, this.item + " is not craftable"});
            this.exception = new LuaException(this.item + " is not craftable");
            return;
        }
        this.count.ifPresent(arg_0 -> ((IAEItemStack)aeItem).setStackSize(arg_0));
        crafting.beginCraftingJob(this.world, grid, this.source, aeItem, (ICraftingCallback)this);
    }

    public void calculationComplete(ICraftingJob job) {
        ServerWorker.add(() -> this.calcComplete(job));
    }

    private void calcComplete(ICraftingJob job) {
        if (job.isSimulation()) {
            this.computer.queueEvent(EVENT, new Object[]{null, "the me system has no ingredients for the crafting job"});
            this.result = MethodResult.of((Object[])new Object[]{false, "the me system has no ingredients for the crafting job"});
            this.exception = new LuaException("the me system has no ingredients for the crafting job");
            return;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            this.computer.queueEvent(EVENT, new Object[]{null, "not connected"});
            this.result = MethodResult.of((Object[])new Object[]{null, "not connected"});
            this.exception = new LuaException("not connected");
            return;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        IMEMonitor monitor = storage.getInventory(AppEngApi.getInstance().getApi().storage().getStorageChannel(IItemStorageChannel.class));
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        ICraftingLink link = crafting.submitJob(job, null, null, false, this.source);
        if (link == null) {
            this.computer.queueEvent(EVENT, new Object[]{null, "an unexpected error has occurred"});
            this.result = MethodResult.of((Object[])new Object[]{false, "an unexpected error has occurred"});
            this.exception = new LuaException("grid is null");
        } else {
            this.computer.queueEvent(EVENT, new Object[]{null});
            this.result = MethodResult.of((Object)AppEngApi.getInstance().getObjectFromJob(job));
        }
    }

    @NotNull
    public MethodResult resume(Object[] objects) {
        if (this.result != null) {
            return this.result;
        }
        if (this.exception != null) {
            return MethodResult.of((Object)this.exception);
        }
        return MethodResult.of();
    }
}

