/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.AEAddon;
import appeng.api.IAEAddon;
import appeng.api.IAppEngApi;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import dan200.computercraft.shared.util.NBTUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@AEAddon
public class AppEngApi
implements IAEAddon {
    public static final AppEngApi INSTANCE = new AppEngApi();
    private static IAppEngApi api;

    public static AppEngApi getInstance() {
        return INSTANCE;
    }

    public void onAPIAvailable(IAppEngApi iAppEngApi) {
        api = iAppEngApi;
    }

    public IAppEngApi getApi() {
        return api;
    }

    public IAEItemStack findAEStackFromItemStack(IMEMonitor<IAEItemStack> monitor, ItemStack item) {
        IAEItemStack stack = null;
        for (IAEItemStack temp : monitor.getStorageList()) {
            if (!temp.isSameType(item)) continue;
            stack = temp;
            break;
        }
        return stack;
    }

    public HashMap<Integer, Object> iteratorToMapStack(Iterator<IAEItemStack> iterator, int flag) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int i = 1;
        while (iterator.hasNext()) {
            Object o = this.getObjectFromStack(iterator.next(), flag);
            if (o == null) continue;
            map.put(i++, o);
        }
        return map;
    }

    public HashMap<Integer, Object> iteratorToMapFluid(Iterator<IAEFluidStack> iterator, int flag) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int i = 1;
        while (iterator.hasNext()) {
            Object o = this.getObjectFromStack(iterator.next(), flag);
            if (o == null) continue;
            map.put(i++, o);
        }
        return map;
    }

    public Object getObjectFromStack(IAEItemStack stack, int flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResourceLocation itemResourceLocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.getItem());
        Item item = stack.getItem();
        String itemName = itemResourceLocation == null ? "null" : itemResourceLocation.toString();
        String displayName = new ItemStack((IItemProvider)item).func_200301_q().getString();
        CompoundNBT nbt = stack.createItemStack().func_196082_o();
        map.put("name", itemName);
        map.put("amount", stack.getStackSize());
        map.put("displayName", displayName);
        map.put("nbt", nbt.toString());
        map.put("tags", item.getTags());
        if (flag == 0) {
            return map;
        }
        if (flag == 1) {
            if (stack.getStackSize() > 0L) {
                return map;
            }
        } else if (flag == 2) {
            if (stack.isCraftable()) {
                return map;
            }
        } else if (flag >= 3) {
            throw new IllegalArgumentException("flag cannot be " + flag);
        }
        return null;
    }

    public Object getObjectFromStack(IAEItemStack stack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResourceLocation itemResourceLocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.getItem());
        String itemName = itemResourceLocation == null ? "null" : itemResourceLocation.toString();
        String displayName = new ItemStack((IItemProvider)stack.getItem()).func_200301_q().getString();
        CompoundNBT nbt = stack.createItemStack().func_196082_o();
        map.put("name", itemName);
        map.put("amount", stack.getStackSize());
        map.put("displayName", displayName);
        map.put("nbt", nbt.toString());
        return map;
    }

    public Map<Object, Object> getMapFromStack(IAEItemStack stack) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ResourceLocation itemResourceLocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.getItem());
        String itemName = itemResourceLocation == null ? "null" : itemResourceLocation.toString();
        long amount = stack.getStackSize();
        String displayName = new ItemStack((IItemProvider)stack.getItem()).func_200301_q().getString();
        CompoundNBT nbt = stack.createItemStack().func_196082_o();
        map.put("name", itemName);
        map.put("amount", amount);
        map.put("displayName", displayName);
        map.put("nbt", nbt.toString());
        return map;
    }

    public Object getObjectFromStack(IAEFluidStack stack, int flag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResourceLocation itemResourceLocation = ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)stack.getFluid());
        Fluid fluid = stack.getFluid();
        String itemName = itemResourceLocation == null ? "null" : itemResourceLocation.toString();
        long amount = stack.getStackSize();
        String displayName = stack.getFluidStack().getDisplayName().getString();
        map.put("name", itemName);
        map.put("amount", amount);
        map.put("displayName", displayName);
        map.put("tags", fluid.getTags());
        if (flag == 0) {
            return map;
        }
        if (flag == 1) {
            if (stack.getStackSize() > 0L) {
                return map;
            }
        } else if (flag == 2) {
            if (stack.isCraftable()) {
                return map;
            }
        } else if (flag >= 3) {
            throw new IllegalArgumentException("flag cannot be " + flag);
        }
        return null;
    }

    public Object getObjectFromCPU(ICraftingCPU cpu) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        long storage = cpu.getAvailableStorage();
        int coProcessors = cpu.getCoProcessors();
        boolean isBusy = cpu.isBusy();
        map.put("storage", Long.valueOf(storage));
        map.put("coProcessors", Integer.valueOf(coProcessors));
        map.put("isBusy", Boolean.valueOf(isBusy));
        return map;
    }

    public Object getObjectFromJob(ICraftingJob job) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        HashMap<String, Map<Object, Object>> stack = new HashMap<String, Map<Object, Object>>();
        stack.put("item", this.getMapFromStack(job.getOutput()));
        result.put("stack", stack);
        result.put("bytes", Long.valueOf(job.getByteTotal()));
        return result;
    }

    public CompoundNBT findMatchingTag(ItemStack stack, String nbtHash, IMEMonitor<IAEItemStack> monitor) {
        IItemList itemStacks = monitor.getStorageList();
        for (IAEItemStack aeStack : itemStacks) {
            if (aeStack.getStackSize() <= 0L || !aeStack.getItem().equals(stack.func_77973_b())) continue;
            AdvancedPeripherals.Debug(aeStack + "");
            CompoundNBT tag = aeStack.createItemStack().func_77978_p();
            String hash = NBTUtil.getNBTHash((CompoundNBT)tag);
            AdvancedPeripherals.Debug("HASH: " + hash);
            AdvancedPeripherals.Debug("TAG: " + tag);
            if (!nbtHash.equals(hash)) continue;
            return tag.func_74737_b();
        }
        return null;
    }
}

