/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.client;

import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="advancedperipherals", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistry {
    private static final String[] TURTLE_MODELS = new String[]{"turtle_chat_box_upgrade_left", "turtle_chat_box_upgrade_right", "turtle_environment_upgrade_left", "turtle_environment_upgrade_right", "turtle_player_upgrade_left", "turtle_player_upgrade_right"};

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        ModelLoader loader = event.getModelLoader();
        Map registry = event.getModelRegistry();
        for (String modelName : TURTLE_MODELS) {
            ResourceLocation location = new ResourceLocation("advancedperipherals", "item/" + modelName);
            IUnbakedModel model = loader.getModelOrMissing(location);
            model.func_225614_a_(arg_0 -> ((ModelLoader)loader).getModelOrMissing(arg_0), new HashSet());
            IBakedModel baked = model.func_225613_a_((ModelBakery)loader, ModelLoader.defaultTextureGetter(), (IModelTransform)SimpleModelTransform.IDENTITY, location);
            if (baked == null) continue;
            registry.put(new ModelResourceLocation(new ResourceLocation("advancedperipherals", modelName), "inventory"), baked);
        }
    }
}

