/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import flaxbeard.immersivepetroleum.api.crafting.SulfurRecoveryRecipe;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class SulfurRecoveryRecipeCategory
extends IPRecipeCategory<SulfurRecoveryRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("immersivepetroleum", "hydrotreater");
    private final IDrawableStatic tankOverlay;

    public SulfurRecoveryRecipeCategory(IGuiHelper guiHelper) {
        super(SulfurRecoveryRecipe.class, guiHelper, ID, "block.immersivepetroleum.hydrotreater");
        ResourceLocation background = new ResourceLocation("immersivepetroleum", "textures/gui/jei/hydrotreater.png");
        this.setBackground(guiHelper.createDrawable(background, 0, 0, 113, 75));
        this.setIcon(new ItemStack((IItemProvider)IPContent.Multiblock.hydrotreater));
        this.tankOverlay = guiHelper.createDrawable(background, 113, 0, 20, 51);
    }

    public void setIngredients(SulfurRecoveryRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.FLUID, recipe.inputFluid.getMatchingFluidStacks());
        if (recipe.inputFluidSecondary != null) {
            ingredients.setInputs(VanillaTypes.FLUID, recipe.inputFluidSecondary.getMatchingFluidStacks());
        }
        ingredients.setOutputs(VanillaTypes.FLUID, Arrays.asList(recipe.output));
        ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.outputItem));
    }

    public void setRecipe(IRecipeLayout recipeLayout, SulfurRecoveryRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int id = 0;
        guiFluidStacks.init(id, true, 25, 3, 20, 51, 1, false, (IDrawable)this.tankOverlay);
        guiFluidStacks.set(id++, recipe.inputFluid.getMatchingFluidStacks());
        guiFluidStacks.init(id, true, 3, 3, 20, 51, 1, false, (IDrawable)this.tankOverlay);
        guiFluidStacks.set(id++, (List)(recipe.inputFluidSecondary != null ? recipe.inputFluidSecondary.getMatchingFluidStacks() : Arrays.asList(FluidStack.EMPTY)));
        guiFluidStacks.init(id, false, 71, 3, 20, 51, 1, false, (IDrawable)this.tankOverlay);
        guiFluidStacks.set(id++, recipe.output);
        guiItemStacks.init(id, false, 93, 20);
        guiItemStacks.set(id++, Arrays.asList(recipe.outputItem));
    }

    public void draw(SulfurRecoveryRecipe recipe, MatrixStack matrix, double mouseX, double mouseY) {
        super.draw((Object)recipe, matrix, mouseX, mouseY);
        DecimalFormat formatter = new DecimalFormat("#.##");
        IDrawable background = this.getBackground();
        int bWidth = background.getWidth();
        int bHeight = background.getHeight();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int time = recipe.getTotalProcessTime();
        int energy = recipe.getTotalProcessEnergy();
        int chance = (int)(100.0 * recipe.chance);
        String text0 = I18n.func_135052_a((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{formatter.format(energy)});
        float f = bWidth / 2 - font.func_78256_a(text0) / 2;
        font.getClass();
        font.func_238421_b_(matrix, text0, f, (float)(bHeight - 9 * 2), 0);
        String text1 = I18n.func_135052_a((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{formatter.format((double)time / 20.0)});
        float f2 = bWidth / 2 - font.func_78256_a(text1) / 2;
        font.getClass();
        font.func_238421_b_(matrix, text1, f2, (float)(bHeight - 9), 0);
        String text2 = String.format(Locale.US, "%d%%", chance);
        font.func_238421_b_(matrix, text2, (float)(bWidth + 3 - font.func_78256_a(text2)), (float)(bHeight / 2 + 4), 0);
    }
}

