/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class SulfurRecoveryRecipe
extends IPMultiblockRecipe {
    public static final IRecipeType<SulfurRecoveryRecipe> TYPE = IRecipeType.func_222147_a((String)"immersivepetroleum:hydrotreater");
    public static Map<ResourceLocation, SulfurRecoveryRecipe> recipes = new HashMap<ResourceLocation, SulfurRecoveryRecipe>();
    public final ItemStack outputItem;
    public final double chance;
    public final FluidStack output;
    public final FluidTagInput inputFluid;
    @Nullable
    public final FluidTagInput inputFluidSecondary;

    public static SulfurRecoveryRecipe findRecipe(@Nonnull FluidStack input, @Nonnull FluidStack secondary) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(secondary);
        for (SulfurRecoveryRecipe recipe : recipes.values()) {
            if (recipe.inputFluid == null || !recipe.inputFluid.test(input) || !secondary.isEmpty() && (recipe.inputFluidSecondary == null || secondary == null || !recipe.inputFluidSecondary.test(secondary))) continue;
            return recipe;
        }
        return null;
    }

    public static boolean hasRecipeWithInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (SulfurRecoveryRecipe recipe : recipes.values()) {
                if (recipe.inputFluid == null || (ignoreAmount || !recipe.inputFluid.test(fluid)) && (!ignoreAmount || !recipe.inputFluid.testIgnoringAmount(fluid))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeWithSecondaryInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (SulfurRecoveryRecipe recipe : recipes.values()) {
                if (recipe.inputFluidSecondary == null || (ignoreAmount || !recipe.inputFluidSecondary.test(fluid)) && (!ignoreAmount || !recipe.inputFluidSecondary.testIgnoringAmount(fluid))) continue;
                return true;
            }
        }
        return false;
    }

    public SulfurRecoveryRecipe(ResourceLocation id, FluidStack output, ItemStack outputItem, FluidTagInput inputFluid, @Nullable FluidTagInput inputFluidSecondary, double chance, int energy, int time) {
        super(ItemStack.field_190927_a, TYPE, id);
        FluidTagInput[] fluidTagInputArray;
        this.output = output;
        this.outputItem = outputItem;
        this.inputFluid = inputFluid;
        this.inputFluidSecondary = inputFluidSecondary;
        this.chance = chance;
        this.fluidOutputList = Arrays.asList(output);
        if (inputFluidSecondary != null) {
            FluidTagInput[] fluidTagInputArray2 = new FluidTagInput[2];
            fluidTagInputArray2[0] = inputFluid;
            fluidTagInputArray = fluidTagInputArray2;
            fluidTagInputArray2[1] = inputFluidSecondary;
        } else {
            FluidTagInput[] fluidTagInputArray3 = new FluidTagInput[1];
            fluidTagInputArray = fluidTagInputArray3;
            fluidTagInputArray3[0] = inputFluid;
        }
        this.fluidInputList = Arrays.asList(fluidTagInputArray);
        this.timeAndEnergy(time, energy);
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.hydrotreater_timeModifier.get(), () -> IPServerConfig.REFINING.hydrotreater_energyModifier.get());
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public FluidTagInput getInputFluid() {
        return this.inputFluid;
    }

    @Nullable
    public FluidTagInput getSecondaryInputFluid() {
        return this.inputFluidSecondary;
    }

    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        NonNullList list = NonNullList.func_191196_a();
        if ((double)tile.func_145831_w().field_73012_v.nextFloat() <= this.chance) {
            list.add((Object)this.outputItem);
        }
        return list;
    }

    protected IERecipeSerializer<SulfurRecoveryRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.HYDROTREATER_SERIALIZER.get();
    }
}

