/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import java.util.function.DoubleSupplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;

public abstract class IPMultiblockRecipe
extends MultiblockRecipe {
    Lazy<Integer> totalProcessTime;
    Lazy<Integer> totalProcessEnergy;

    protected IPMultiblockRecipe(ItemStack outputDummy, IRecipeType<?> type, ResourceLocation id) {
        super(outputDummy, type, id);
    }

    protected void timeAndEnergy(int time, int energy) {
        this.totalProcessEnergy = Lazy.of(() -> energy);
        this.totalProcessTime = Lazy.of(() -> time);
    }

    public void modifyTimeAndEnergy(DoubleSupplier timeModifier, DoubleSupplier energyModifier) {
        Lazy<Integer> oldTime = this.totalProcessTime;
        Lazy<Integer> oldEnergy = this.totalProcessEnergy;
        this.totalProcessTime = Lazy.of(() -> (int)Math.max(1.0, (double)((Integer)oldTime.get()).intValue() * timeModifier.getAsDouble()));
        this.totalProcessEnergy = Lazy.of(() -> (int)Math.max(1.0, (double)((Integer)oldEnergy.get()).intValue() * energyModifier.getAsDouble()));
    }

    public int getTotalProcessTime() {
        return (Integer)this.totalProcessTime.get();
    }

    public int getTotalProcessEnergy() {
        return (Integer)this.totalProcessEnergy.get();
    }
}

