/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.enums.IVariantMaterial;
import svenhjol.charm.base.enums.VanillaVariantMaterial;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.block.VariantLadderBlock;
import svenhjol.charm.client.VariantLaddersClient;

@Module(mod="charm", client=VariantLaddersClient.class, description="Ladders available in all types of vanilla wood.")
public class VariantLadders
extends CharmModule {
    public static final Map<IVariantMaterial, VariantLadderBlock> LADDER_BLOCKS = new HashMap<IVariantMaterial, VariantLadderBlock>();
    @Config(name="Override", description="This module is automatically disabled if Quark is present. Set true to force enable.")
    public static boolean override = false;

    @Override
    public void register() {
        VanillaVariantMaterial.getTypes().forEach(type -> LADDER_BLOCKS.put((IVariantMaterial)type, new VariantLadderBlock(this, (IVariantMaterial)type)));
    }

    @Override
    public boolean depends() {
        return !ModuleHandler.enabled("quark:building.module.variant_ladders_module") || override;
    }

    public static boolean canEnterTrapdoor(World world, BlockPos pos, BlockState state) {
        if (ModuleHandler.enabled(VariantLadders.class) && ((Boolean)state.func_177229_b((Property)TrapDoorBlock.field_176283_b)).booleanValue()) {
            BlockState down = world.func_180495_p(pos.func_177977_b());
            return LADDER_BLOCKS.values().stream().anyMatch(b -> b == down.func_177230_c()) && down.func_177229_b((Property)LadderBlock.field_176382_a) == state.func_177229_b((Property)TrapDoorBlock.field_185512_D);
        }
        return false;
    }

    @Override
    public List<ResourceLocation> getRecipesToRemove() {
        return Arrays.asList(new ResourceLocation("charm", "woodcutters/vanilla_ladder_from_planks"));
    }
}

