/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.mixin.accessor.ServerWorldAccessor;

@Module(mod="charm", description="Allows the night to pass when a specified number of players are asleep.", hasSubscriptions=true)
public class SleepImprovements
extends CharmModule {
    @Config(name="Faster sleep", description="If true, the sleeping player does not need to wait as long before ending the night.")
    public static boolean fasterSleep = false;
    @Config(name="Number of required players", description="The number of players required to sleep in order to bring the next day.")
    public static int requiredPlayers = 1;
    @Config(name="Override", description="This module is automatically disabled if Quark is present. Set true to force enable.")
    public static boolean override = false;

    @Override
    public boolean depends() {
        return !ModuleHandler.enabled("quark:tweaks.module.improved_sleeping_module") || override;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.isCanceled() && event.side != LogicalSide.CLIENT) {
            this.tryEndNight((ServerWorld)event.world);
        }
    }

    private void tryEndNight(ServerWorld world) {
        if (world == null || world.func_82737_E() % 20L != 0L || !world.func_234923_W_().equals(World.field_234918_g_)) {
            return;
        }
        MinecraftServer server = world.func_73046_m();
        int currentPlayerCount = world.func_73046_m().func_71233_x();
        if (currentPlayerCount < requiredPlayers) {
            return;
        }
        List validPlayers = server.func_184103_al().func_181057_v().stream().filter(p -> !p.func_175149_v() && (fasterSleep ? p.func_70608_bn() : p.func_71026_bH())).collect(Collectors.toList());
        if (validPlayers.size() < requiredPlayers) {
            return;
        }
        if (world.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
            long l = world.func_72820_D() + 24000L;
            world.func_241114_a_(l - l % 24000L);
        }
        ((ServerWorldAccessor)world).invokeWakeUpAllPlayers();
        if (world.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
            ((ServerWorldAccessor)world).invokeResetRainAndThunder();
        }
    }
}

