/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.item;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.base.item.CharmItem;
import svenhjol.charm.mixin.accessor.PatrolSpawnerAccessor;
import svenhjol.charm.mixin.accessor.ServerWorldAccessor;
import svenhjol.charm.module.RaidHorns;

public class RaidHornItem
extends CharmItem {
    public RaidHornItem(CharmModule module) {
        super(module, "raid_horn", new Item.Properties().func_200917_a(1).func_200918_c(16).func_200916_a(ItemGroup.field_78026_f));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity user, Hand hand) {
        ItemStack horn = user.func_184586_b(hand);
        if (!world.field_72995_K) {
            world.func_184133_a(null, user.func_233580_cy_(), CharmSounds.RAID_HORN, SoundCategory.PLAYERS, (float)RaidHorns.volume, 1.0f);
            user.func_184598_c(hand);
        }
        return ActionResult.func_226249_b_((Object)horn);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity user, int remainingUseTicks) {
        if (world.field_72995_K) {
            return;
        }
        if (RaidHornItem.getPullProgress(this.func_77626_a(stack) - remainingUseTicks) < 1.0f) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        BlockPos pos = user.func_233580_cy_();
        if (serverWorld.func_217455_d_(pos)) {
            Raid raid = serverWorld.func_217475_c_(pos);
            if (raid != null) {
                raid.func_221295_o();
            }
        } else if (user instanceof PlayerEntity) {
            this.trySpawnPillagers(serverWorld, (PlayerEntity)user);
        }
        if (user instanceof PlayerEntity) {
            ((PlayerEntity)user).func_184811_cZ().func_185145_a((Item)this, 100);
        }
        stack.func_222118_a(1, user, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public static float getPullProgress(int useTicks) {
        float f = (float)useTicks / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private void trySpawnPillagers(ServerWorld world, PlayerEntity player) {
        PatrolSpawner pillagerSpawner = null;
        List<ISpecialSpawner> spawners = ((ServerWorldAccessor)world).getSpawners();
        for (ISpecialSpawner spawner : spawners) {
            if (!(spawner instanceof PatrolSpawner)) continue;
            pillagerSpawner = (PatrolSpawner)spawner;
            break;
        }
        if (pillagerSpawner == null) {
            return;
        }
        Random random = world.func_201674_k();
        int j = (24 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1);
        int k = (24 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1);
        BlockPos.Mutable mutable = player.func_233580_cy_().func_239590_i_().func_196234_d(j, 0, k);
        if (!world.func_217344_a(mutable.func_177958_n() - 10, mutable.func_177956_o() - 10, mutable.func_177952_p() - 10, mutable.func_177958_n() + 10, mutable.func_177956_o() + 10, mutable.func_177952_p() + 10)) {
            return;
        }
        Biome biome = world.func_226691_t_((BlockPos)mutable);
        Biome.Category category = biome.func_201856_r();
        if (category == Biome.Category.MUSHROOM) {
            return;
        }
        int m = 0;
        int n = (int)Math.ceil(world.func_175649_E((BlockPos)mutable).func_180168_b()) + 1;
        for (int o = 0; o < n; ++o) {
            ++m;
            mutable.func_185336_p(world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutable).func_177956_o());
            if (o == 0) {
                if (!((PatrolSpawnerAccessor)pillagerSpawner).invokeSpawnPatroller(world, (BlockPos)mutable, random, true)) {
                    break;
                }
            } else {
                ((PatrolSpawnerAccessor)pillagerSpawner).invokeSpawnPatroller(world, (BlockPos)mutable, random, false);
            }
            mutable.func_223471_o(mutable.func_177958_n() + random.nextInt(5) - random.nextInt(5));
            mutable.func_223472_q(mutable.func_177952_p() + random.nextInt(5) - random.nextInt(5));
        }
        ((PatrolSpawnerAccessor)pillagerSpawner).setTicksUntilNextSpawn(12000);
    }
}

