/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.container;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.base.helper.ItemNBTHelper;
import svenhjol.charm.container.AtlasContainer;
import svenhjol.charm.module.Atlas;

public class AtlasInventory
implements INamedContainerProvider,
IInventory {
    public static final String EMPTY_MAPS = "empty_maps";
    public static final String FILLED_MAPS = "filled_maps";
    public static final String ACTIVE_MAP = "active_map";
    public static final String SCALE = "scale";
    public static final String ID = "id";
    private static final int EMPTY_MAP_SLOTS = 3;
    private final Table<RegistryKey<World>, Index, MapInfo> mapInfos;
    private final NonNullList<ItemStack> emptyMaps;
    private int diameter;
    private ItemStack atlas;
    private int scale;
    private boolean isOpen = false;

    public AtlasInventory(ItemStack atlas) {
        this.atlas = atlas;
        this.scale = Atlas.defaultScale;
        this.diameter = 128;
        this.emptyMaps = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
        this.mapInfos = HashBasedTable.create();
        this.load();
    }

    public void reload(ItemStack atlas) {
        this.atlas = atlas;
        this.emptyMaps.clear();
        this.mapInfos.clear();
        this.load();
    }

    private void load() {
        this.scale = ItemNBTHelper.getInt(this.atlas, SCALE, Atlas.defaultScale);
        this.diameter = 128 * (1 << this.scale);
        ItemStackHelper.func_191283_b((CompoundNBT)ItemNBTHelper.getCompound(this.atlas, EMPTY_MAPS), this.emptyMaps);
        ListNBT listNBT = ItemNBTHelper.getList(this.atlas, FILLED_MAPS);
        for (int i = 0; i < listNBT.size(); ++i) {
            this.putMapInfo(MapInfo.readFrom(listNBT.func_150305_b(i)));
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private void putMapInfo(MapInfo mapInfo) {
        this.mapInfos.put(mapInfo.dimension, (Object)this.convertCoordsToIndex(mapInfo.x, mapInfo.z), (Object)mapInfo);
    }

    public Index getIndexOf(PlayerEntity player) {
        return this.convertCoordsToIndex((int)player.func_226277_ct_() + 64, (int)player.func_226281_cx_() + 64);
    }

    public Index convertCoordsToIndex(int x, int y) {
        return Index.of(this.convertCoordToIndex(x), this.convertCoordToIndex(y));
    }

    public int convertCoordToIndex(int coordinate) {
        return Math.floorDiv(coordinate, this.diameter);
    }

    private static MapInfo createMapInfo(World world, ItemStack map) {
        MapData mapData = FilledMapItem.func_195950_a((ItemStack)map, (World)world);
        return mapData != null ? new MapInfo(mapData.field_76201_a, mapData.field_76199_b, FilledMapItem.func_195949_f((ItemStack)map), map, mapData.field_76200_c) : null;
    }

    public boolean updateActiveMap(ServerPlayerEntity player) {
        MapInfo activeMap = (MapInfo)this.mapInfos.get((Object)player.field_70170_p.func_234923_W_(), (Object)this.getIndexOf((PlayerEntity)player));
        boolean madeNewMap = false;
        if (activeMap == null && !this.isOpen) {
            activeMap = this.makeNewMap(player, (int)player.func_226277_ct_(), (int)player.func_226281_cx_());
            boolean bl = madeNewMap = activeMap != null;
        }
        if (activeMap != null) {
            Atlas.sendMapToClient(player, activeMap.map, false);
            ItemNBTHelper.setInt(this.atlas, ACTIVE_MAP, activeMap.id);
        } else {
            ItemNBTHelper.setInt(this.atlas, ACTIVE_MAP, -1);
        }
        return madeNewMap;
    }

    private MapInfo makeNewMap(ServerPlayerEntity player, int x, int z) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = (ItemStack)this.emptyMaps.get(i);
            if (stack.func_77973_b() != Items.field_151148_bJ) continue;
            if (!player.func_184812_l_()) {
                this.func_70298_a(i, 1);
            }
            ItemStack map = FilledMapItem.func_195952_a((World)player.field_70170_p, (int)x, (int)z, (byte)((byte)this.scale), (boolean)true, (boolean)true);
            MapInfo mapInfo = AtlasInventory.createMapInfo(player.field_70170_p, map);
            this.putMapInfo(mapInfo);
            this.func_70296_d();
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_219718_mk, SoundCategory.BLOCKS, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            return mapInfo;
        }
        return null;
    }

    @Nullable
    public MapData getActiveMap(World world) {
        int activeId = ItemNBTHelper.getInt(this.atlas, ACTIVE_MAP, -1);
        return activeId == -1 ? null : world.func_217406_a(FilledMapItem.func_219993_a((int)activeId));
    }

    @Nullable
    public ItemStack getLastActiveMapItem() {
        int activeId = ItemNBTHelper.getInt(this.atlas, ACTIVE_MAP, -1);
        if (activeId == -1) {
            return null;
        }
        return this.mapInfos.values().stream().filter(it -> it.id == activeId).findAny().map(it -> it.map).orElse(null);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.atlas.func_200301_q();
    }

    @Nullable
    public Container createMenu(int syncId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new AtlasContainer(syncId, playerInventory, this);
    }

    public int func_70302_i_() {
        return 3;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.emptyMaps) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return this.mapInfos.isEmpty();
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.emptyMaps.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.emptyMaps, (int)index, (int)count);
        this.func_70296_d();
        return itemstack;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = ItemStackHelper.func_188383_a(this.emptyMaps, (int)index);
        this.func_70296_d();
        return itemStack;
    }

    public MapInfo removeMapByCoords(World world, int x, int z) {
        MapInfo info = (MapInfo)this.mapInfos.remove((Object)world.func_234923_W_(), (Object)this.convertCoordsToIndex(x, z));
        this.func_70296_d();
        return info;
    }

    public void addToInventory(World world, ItemStack itemStack) {
        if (itemStack.func_77973_b() == Items.field_151098_aY) {
            this.putMapInfo(AtlasInventory.createMapInfo(world, itemStack));
            this.func_70296_d();
        }
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        if (!((ItemStack)this.emptyMaps.get(index)).equals(stack, true)) {
            this.emptyMaps.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        ItemNBTHelper.setInt(this.atlas, SCALE, this.scale);
        CompoundNBT emptyMapNBT = new CompoundNBT();
        ItemStackHelper.func_191281_a((CompoundNBT)emptyMapNBT, this.emptyMaps, (boolean)false);
        ItemNBTHelper.setCompound(this.atlas, EMPTY_MAPS, emptyMapNBT);
        ListNBT listNBT = new ListNBT();
        for (MapInfo mapInfo : this.mapInfos.values()) {
            CompoundNBT nbt = new CompoundNBT();
            mapInfo.writeTo(nbt);
            listNBT.add((Object)nbt);
        }
        ItemNBTHelper.setList(this.atlas, FILLED_MAPS, listNBT);
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        for (Hand hand : Hand.values()) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() != Atlas.ATLAS_ITEM || !Objects.equals(ItemNBTHelper.getUuid(this.atlas, ID), ItemNBTHelper.getUuid(heldItem, ID))) continue;
            return true;
        }
        return false;
    }

    public void func_174888_l() {
        this.emptyMaps.clear();
        this.mapInfos.clear();
    }

    public void func_174889_b(PlayerEntity player) {
        this.isOpen = true;
        if (!player.field_70170_p.field_72995_K) {
            player.func_213823_a(CharmSounds.BOOKSHELF_OPEN, SoundCategory.BLOCKS, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void func_174886_c(PlayerEntity player) {
        this.isOpen = false;
        if (!player.field_70170_p.field_72995_K) {
            player.func_213823_a(CharmSounds.BOOKSHELF_CLOSE, SoundCategory.BLOCKS, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean hasItemStack(ItemStack stack) {
        return Stream.concat(this.emptyMaps.stream(), this.mapInfos.values().stream().map(it -> it.map)).anyMatch(it -> !it.func_190926_b() && it.func_77969_a(stack));
    }

    public ItemStack getAtlasItem() {
        return this.atlas;
    }

    public Table<RegistryKey<World>, Index, MapInfo> getMapInfos() {
        return this.mapInfos;
    }

    public Map<Index, MapInfo> getCurrentDimensionMapInfos(World world) {
        return this.mapInfos.row((Object)world.func_234923_W_());
    }

    public int getScale() {
        return this.scale;
    }

    public static class Index {
        private static final Int2ObjectMap<Int2ObjectMap<Index>> cache = new Int2ObjectOpenHashMap();
        public final int x;
        public final int y;

        private Index(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Index plus(Index value) {
            return Index.transform(it -> (Integer)it.apply(this) + (Integer)it.apply(value));
        }

        public Index plus(int value) {
            return Index.transform(it -> (Integer)it.apply(this) + value);
        }

        public Index minus(Index value) {
            return Index.transform(it -> (Integer)it.apply(this) - (Integer)it.apply(value));
        }

        public Index minus(int value) {
            return Index.transform(it -> (Integer)it.apply(this) - value);
        }

        public Index multiply(int value) {
            return Index.transform(it -> (Integer)it.apply(this) * value);
        }

        public Index clamp(Index min, Index max) {
            return Index.transform(it -> MathHelper.func_76125_a((int)((Integer)it.apply(this)), (int)((Integer)it.apply(min)), (int)((Integer)it.apply(max))));
        }

        public static Index max(Index i1, Index i2) {
            return Index.transform(it -> Math.max((Integer)it.apply(i1), (Integer)it.apply(i2)));
        }

        private static Index transform(Function<Function<Index, Integer>, Integer> transformer) {
            return Index.of(transformer.apply(it -> it.x), transformer.apply(it -> it.y));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            return this.x == index.x && this.y == index.y;
        }

        public int hashCode() {
            return 7079 * this.x + this.y;
        }

        public static Index of(int x, int y) {
            Index index;
            Int2ObjectMap columnCache = (Int2ObjectMap)cache.get(x);
            if (columnCache == null) {
                columnCache = new Int2ObjectOpenHashMap();
                cache.put(x, (Object)columnCache);
            }
            if ((index = (Index)columnCache.get(y)) == null) {
                index = new Index(x, y);
                columnCache.put(y, (Object)index);
            }
            return index;
        }
    }

    public static class MapInfo {
        private static final String X = "x";
        private static final String Z = "z";
        private static final String ID = "id";
        private static final String MAP = "map";
        private static final String DIMENSION = "dimension";
        public final int x;
        public final int z;
        public final int id;
        public final ItemStack map;
        public final RegistryKey<World> dimension;

        private MapInfo(int x, int z, int id, ItemStack map, RegistryKey<World> dimension) {
            this.x = x;
            this.z = z;
            this.id = id;
            this.map = map;
            this.dimension = dimension;
        }

        public static MapInfo readFrom(CompoundNBT nbt) {
            return new MapInfo(nbt.func_74762_e(X), nbt.func_74762_e(Z), nbt.func_74762_e("id"), ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(MAP)), (RegistryKey<World>)DimensionType.func_236025_a_((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt.func_74781_a(DIMENSION))).result().orElse(World.field_234918_g_));
        }

        public void writeTo(CompoundNBT nbt) {
            nbt.func_74768_a(X, this.x);
            nbt.func_74768_a(Z, this.z);
            nbt.func_74768_a("id", this.id);
            CompoundNBT mapNBT = new CompoundNBT();
            this.map.func_77955_b(mapNBT);
            nbt.func_218657_a(MAP, (INBT)mapNBT);
            ResourceLocation.field_240908_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.dimension.func_240901_a_()).result().ifPresent(it -> nbt.func_218657_a(DIMENSION, it));
        }
    }
}

