/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import svenhjol.charm.base.CharmClientModule;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.enums.ICharmEnum;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.module.VariantMobTextures;
import svenhjol.charm.render.VariantMobRenderer;

public class VariantMobTexturesClient
extends CharmClientModule {
    private static final String PREFIX = "textures/entity/";
    private static final ResourceLocation DEFAULT_SHEEP = new ResourceLocation("textures/entity/sheep/sheep.png");
    public static List<ResourceLocation> chickens = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> cows = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> snowGolems = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> squids = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> pigs = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> wolves = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> rareChickens = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> rareCows = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> rareSquids = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> rarePigs = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> rareWolves = new ArrayList<ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> wolvesTame = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> wolvesAngry = new HashMap<ResourceLocation, ResourceLocation>();
    public static Map<DyeColor, ResourceLocation> sheep = new HashMap<DyeColor, ResourceLocation>();

    public VariantMobTexturesClient(CharmModule module) {
        super(module);
    }

    @Override
    public void init() {
        int i;
        boolean overrideQuark;
        boolean bl = overrideQuark = !ModuleHandler.enabled("quark:client.module.variant_animal_textures_module") || VariantMobTextures.override;
        if (VariantMobTextures.variantChickens && overrideQuark) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200795_i, VariantMobRenderer.Chicken::new);
        }
        if (VariantMobTextures.variantCows && overrideQuark) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200796_j, VariantMobRenderer.Cow::new);
        }
        if (VariantMobTextures.variantPigs && overrideQuark) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200784_X, VariantMobRenderer.Pig::new);
        }
        if (VariantMobTextures.variantSheep) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200737_ac, VariantMobRenderer.Sheep::new);
        }
        if (VariantMobTextures.variantSnowGolems) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200745_ak, VariantMobRenderer.SnowGolem::new);
        }
        if (VariantMobTextures.variantSquids) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200749_ao, VariantMobRenderer.Squid::new);
        }
        if (VariantMobTextures.variantWolves) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200724_aC, VariantMobRenderer.Wolf::new);
        }
        chickens = new ArrayList<ResourceLocation>();
        cows = new ArrayList<ResourceLocation>();
        pigs = new ArrayList<ResourceLocation>();
        snowGolems = new ArrayList<ResourceLocation>();
        squids = new ArrayList<ResourceLocation>();
        wolves = new ArrayList<ResourceLocation>();
        wolvesTame = new HashMap<ResourceLocation, ResourceLocation>();
        wolvesAngry = new HashMap<ResourceLocation, ResourceLocation>();
        rareChickens = new ArrayList<ResourceLocation>();
        rareCows = new ArrayList<ResourceLocation>();
        rarePigs = new ArrayList<ResourceLocation>();
        rareSquids = new ArrayList<ResourceLocation>();
        rareWolves = new ArrayList<ResourceLocation>();
        chickens.add(new ResourceLocation("textures/entity/chicken.png"));
        cows.add(new ResourceLocation("textures/entity/cow/cow.png"));
        pigs.add(new ResourceLocation("textures/entity/pig/pig.png"));
        snowGolems.add(new ResourceLocation("textures/entity/snow_golem.png"));
        squids.add(new ResourceLocation("textures/entity/squid.png"));
        ResourceLocation wolf = new ResourceLocation("textures/entity/wolf/wolf.png");
        wolves.add(wolf);
        wolvesTame.put(wolf, new ResourceLocation("textures/entity/wolf/wolf_tame.png"));
        wolvesAngry.put(wolf, new ResourceLocation("textures/entity/wolf/wolf_angry.png"));
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(chickens, MobType.CHICKEN, "chicken" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(rareChickens, MobType.CHICKEN, "rare_chicken" + i);
        }
        for (i = 1; i <= 7; ++i) {
            this.addCustomTextures(cows, MobType.COW, "cow" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareCows, MobType.COW, "rare_cow" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(pigs, MobType.PIG, "pig" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addCustomTextures(rarePigs, MobType.PIG, "rare_pig" + i);
        }
        for (i = 1; i <= 5; ++i) {
            this.addCustomTextures(snowGolems, MobType.SNOW_GOLEM, "snow_golem" + i);
        }
        for (i = 1; i <= 4; ++i) {
            this.addCustomTextures(squids, MobType.SQUID, "squid" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareSquids, MobType.SQUID, "rare_squid" + i);
        }
        for (i = 1; i <= 25; ++i) {
            this.addCustomTextures(wolves, MobType.WOLF, "nlg_wolf" + i);
        }
        for (i = 1; i <= 1; ++i) {
            this.addCustomTextures(rareWolves, MobType.WOLF, "rare_wolf" + i);
        }
        this.addCustomTextures(wolves, MobType.WOLF, "brownwolf", "greywolf", "blackwolf", "amotwolf", "jupiter1390");
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation res = this.createResource(MobType.SHEEP, "sheep_" + color.toString());
            sheep.put(color, res);
        }
    }

    public void addCustomTextures(List<ResourceLocation> set, MobType type, String ... names) {
        ArrayList<String> textures = new ArrayList<String>(Arrays.asList(names));
        textures.forEach(texture -> {
            ResourceLocation res = this.createResource(type, (String)texture);
            set.add(res);
            if (type == MobType.WOLF) {
                wolvesTame.put(res, this.createResource(type, texture + "_tame"));
                wolvesAngry.put(res, this.createResource(type, texture + "_angry"));
            }
        });
    }

    public static ResourceLocation getChickenTexture(ChickenEntity entity) {
        return VariantMobTexturesClient.getRandomTexture((Entity)entity, chickens, rareChickens);
    }

    public static ResourceLocation getCowTexture(CowEntity entity) {
        return VariantMobTexturesClient.getRandomTexture((Entity)entity, cows, rareCows);
    }

    public static ResourceLocation getPigTexture(PigEntity entity) {
        return VariantMobTexturesClient.getRandomTexture((Entity)entity, pigs, rarePigs);
    }

    public static ResourceLocation getSheepTexture(SheepEntity entity) {
        DyeColor fleeceColor = entity.func_175509_cj();
        return sheep.getOrDefault(fleeceColor, DEFAULT_SHEEP);
    }

    public static ResourceLocation getSnowGolemTexture(SnowGolemEntity entity) {
        return VariantMobTexturesClient.getRandomTexture((Entity)entity, snowGolems, (List<ResourceLocation>)ImmutableList.of());
    }

    public static ResourceLocation getSquidTexture(SquidEntity entity) {
        return VariantMobTexturesClient.getRandomTexture((Entity)entity, squids, rareSquids);
    }

    public static ResourceLocation getWolfTexture(WolfEntity entity) {
        ResourceLocation res = VariantMobTexturesClient.getRandomTexture((Entity)entity, wolves, rareWolves);
        if (entity.func_70909_n()) {
            res = wolvesTame.get(res);
        } else if (entity.func_241357_a_(entity.field_70170_p)) {
            res = wolvesAngry.get(res);
        }
        return res;
    }

    public static ResourceLocation getRandomTexture(Entity entity, List<ResourceLocation> normalSet, List<ResourceLocation> rareSet) {
        UUID id = entity.func_110124_au();
        boolean isRare = VariantMobTextures.rareVariants && !rareSet.isEmpty() && (id.getLeastSignificantBits() + id.getMostSignificantBits()) % (long)VariantMobTextures.rarity == 0L;
        List<ResourceLocation> set = isRare ? rareSet : normalSet;
        int choice = Math.abs((int)(id.getMostSignificantBits() % (long)set.size()));
        return set.get(choice);
    }

    private ResourceLocation createResource(MobType type, String texture) {
        return new ResourceLocation("charm", PREFIX + type.func_176610_l() + "/" + texture + ".png");
    }

    public static enum MobType implements ICharmEnum
    {
        WOLF,
        COW,
        PIG,
        CHICKEN,
        SQUID,
        SHEEP,
        SNOW_GOLEM;

    }
}

