/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.Charm;
import svenhjol.charm.CharmClient;
import svenhjol.charm.base.CharmClientModule;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.helper.DimensionHelper;
import svenhjol.charm.base.helper.SoundHelper;
import svenhjol.charm.module.MusicImprovements;

public class MusicImprovementsClient
extends CharmClientModule {
    private ISound musicToStop = null;
    private int ticksBeforeStop = 0;
    private static ISound currentMusic;
    private static ResourceLocation currentDim;
    private static int timeUntilNextMusic;
    private static MusicCondition lastCondition;
    private static final List<MusicCondition> musicConditions;
    public static boolean isEnabled;

    public MusicImprovementsClient(CharmModule module) {
        super(module);
    }

    @Override
    public void register() {
        isEnabled = this.module.enabled;
        if (MusicImprovements.playCreativeMusic) {
            this.addCreativeMusicCondition();
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.isCanceled()) {
            this.stopRecord(event.getEntity(), event.getPos(), event.getItemStack());
        }
    }

    @SubscribeEvent
    public void onSoundSource(SoundEvent.SoundSourceEvent event) {
        if (!event.isCanceled()) {
            this.checkShouldStopMusic(event.getSound());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!event.isCanceled()) {
            this.checkActuallyStopMusic();
        }
    }

    public void addCreativeMusicCondition() {
        musicConditions.add(new MusicCondition(SoundEvents.field_187792_dx, 1200, 3600, mc -> {
            if (mc.field_71439_g == null) return false;
            if (mc.field_71439_g.func_184812_l_()) {
                if (mc.field_71439_g.func_175149_v()) return false;
            }
            if (!DimensionHelper.isDimension(mc.field_71439_g.field_70170_p, World.field_234918_g_.func_240901_a_())) return false;
            Random random = new Random();
            if (!(random.nextFloat() < 0.25f)) return false;
            return true;
        }));
    }

    public void stopRecord(Entity entity, BlockPos pos, ItemStack stack) {
        BlockState state;
        if (entity.field_70170_p.field_72995_K && entity instanceof PlayerEntity && stack.func_77973_b() instanceof MusicDiscItem && (state = entity.field_70170_p.func_180495_p(pos)).func_177230_c() == Blocks.field_150421_aI && !((Boolean)state.func_177229_b((Property)JukeboxBlock.field_176432_a)).booleanValue()) {
            SoundHelper.getSoundManager().func_195478_a(null, SoundCategory.MUSIC);
        }
    }

    public void checkShouldStopMusic(ISound sound) {
        if (sound.func_184365_d() == SoundCategory.MUSIC) {
            SoundHelper.getPlayingSounds().forEach((category, s) -> {
                if (category == SoundCategory.RECORDS) {
                    this.musicToStop = sound;
                    Charm.LOG.debug("[Music Improvements] Triggered background music while music disc playing");
                }
            });
        }
    }

    public void checkActuallyStopMusic() {
        if (this.musicToStop != null && ++this.ticksBeforeStop % 10 == 0) {
            SoundHelper.getSoundManager().func_147683_b(this.musicToStop);
            this.ticksBeforeStop = 0;
            this.musicToStop = null;
        }
    }

    public static boolean handleTick(ISound current) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return false;
        }
        MusicCondition ambient = MusicImprovementsClient.getMusicCondition();
        if (lastCondition == null) {
            lastCondition = MusicImprovementsClient.getMusicCondition();
        }
        if (currentMusic != null) {
            if (!DimensionHelper.isDimension((World)mc.field_71441_e, currentDim)) {
                CharmClient.LOG.debug("[Music Improvements] Stopping music as the dimension is no longer correct");
                MusicImprovementsClient.forceStop();
                currentMusic = null;
            }
            if (currentMusic != null && !mc.func_147118_V().func_215294_c(currentMusic)) {
                CharmClient.LOG.debug("[Music Improvements] Music has finished, setting currentMusic to null");
                timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)new Random(), (int)lastCondition.getMinDelay(), (int)3600), timeUntilNextMusic);
                currentMusic = null;
            }
        }
        timeUntilNextMusic = Math.min(timeUntilNextMusic, lastCondition.getMaxDelay());
        if (currentMusic == null && timeUntilNextMusic-- <= 0) {
            MusicCondition condition = MusicImprovementsClient.getMusicCondition();
            CharmClient.LOG.debug("[Music Improvements] Selected music condition with sound: " + condition.getSound().func_187503_a());
            MusicImprovementsClient.forceStop();
            currentDim = DimensionHelper.getDimension((World)mc.field_71441_e);
            currentMusic = SimpleSound.func_184370_a((SoundEvent)condition.getSound());
            if (currentMusic.func_184364_b() != SoundHandler.field_147700_a) {
                mc.func_147118_V().func_147682_a(currentMusic);
                lastCondition = condition;
                timeUntilNextMusic = Integer.MAX_VALUE;
            }
        }
        return true;
    }

    public static boolean handleStop() {
        if (currentMusic != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(currentMusic);
            currentMusic = null;
            timeUntilNextMusic = lastCondition != null ? new Random().nextInt(Math.min(lastCondition.getMinDelay(), 3600)) + 1200 : timeUntilNextMusic + 100;
            CharmClient.LOG.debug("[Music Improvements] Stop was called, setting timeout to " + timeUntilNextMusic);
        }
        return true;
    }

    public static boolean handlePlaying(BackgroundMusicSelector music) {
        return currentMusic != null && music.func_232661_a_().func_187503_a().equals((Object)currentMusic.func_147650_b());
    }

    public static void forceStop() {
        Minecraft.func_71410_x().func_147118_V().func_147683_b(currentMusic);
        currentMusic = null;
        timeUntilNextMusic = 3600;
    }

    public static MusicCondition getMusicCondition() {
        MusicCondition condition = null;
        for (MusicCondition c : musicConditions) {
            if (!c.handle()) continue;
            condition = c;
            break;
        }
        if (condition == null) {
            condition = new MusicCondition(Minecraft.func_71410_x().func_238178_U_());
        }
        return condition;
    }

    public static List<MusicCondition> getMusicConditions() {
        return musicConditions;
    }

    static {
        currentDim = null;
        timeUntilNextMusic = 100;
        musicConditions = new ArrayList<MusicCondition>();
    }

    public static class MusicCondition {
        private final SoundEvent sound;
        private final int minDelay;
        private final int maxDelay;
        private Predicate<Minecraft> condition;

        public MusicCondition(SoundEvent sound, int minDelay, int maxDelay, Predicate<Minecraft> condition) {
            this.sound = sound;
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.condition = condition;
        }

        public MusicCondition(BackgroundMusicSelector music) {
            this.sound = music.func_232661_a_();
            this.minDelay = music.func_232664_b_();
            this.maxDelay = music.func_232666_c_();
        }

        public boolean handle() {
            if (this.condition == null) {
                return false;
            }
            return this.condition.test(Minecraft.func_71410_x());
        }

        public SoundEvent getSound() {
            return this.sound;
        }

        public int getMaxDelay() {
            return this.maxDelay;
        }

        public int getMinDelay() {
            return this.minDelay;
        }
    }
}

