/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.HopperScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.BeaconScreen;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.DispenserScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.screen.inventory.MerchantScreen;
import net.minecraft.client.gui.screen.inventory.ShulkerBoxScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmClientModule;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.CharmResources;
import svenhjol.charm.base.gui.CharmContainerScreen;
import svenhjol.charm.message.ServerSortInventory;

public class InventoryTidyingClient
extends CharmClientModule {
    public static final int LEFT = 159;
    public static final int TOP = 12;
    public static final List<ImageButton> sortingButtons = new ArrayList<ImageButton>();
    public final List<Class<? extends Screen>> tileScreens = new ArrayList<Class<? extends Screen>>();
    public final List<Class<? extends Screen>> blacklistScreens = new ArrayList<Class<? extends Screen>>();
    public final Map<Class<? extends Screen>, Map<Integer, Integer>> screenTweaks = new HashMap<Class<? extends Screen>, Map<Integer, Integer>>();

    public InventoryTidyingClient(CharmModule module) {
        super(module);
    }

    @Override
    public void register() {
        if (!this.module.enabled) {
            return;
        }
        this.screenTweaks.put(MerchantScreen.class, (Map<Integer, Integer>)new HashMap<Integer, Integer>(){
            {
                this.put(100, 0);
            }
        });
        this.screenTweaks.put(InventoryScreen.class, (Map<Integer, Integer>)new HashMap<Integer, Integer>(){
            {
                this.put(0, 76);
            }
        });
        this.tileScreens.addAll(Arrays.asList(ChestScreen.class, HopperScreen.class, ShulkerBoxScreen.class, CharmContainerScreen.class, DispenserScreen.class));
        this.blacklistScreens.addAll(Arrays.asList(CreativeScreen.class, BeaconScreen.class));
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!this.module.enabled) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (!(event.getGui() instanceof ContainerScreen)) {
            return;
        }
        if (this.blacklistScreens.contains(event.getGui().getClass())) {
            return;
        }
        sortingButtons.clear();
        ContainerScreen screen = (ContainerScreen)event.getGui();
        Class<?> clazz = screen.getClass();
        Container container = screen.func_212873_a_();
        int x = screen.getGuiLeft() + 159;
        int y = screen.getGuiTop() - 12;
        if (this.screenTweaks.containsKey(clazz)) {
            Map<Integer, Integer> m = this.screenTweaks.get(clazz);
            for (Map.Entry entry : m.entrySet()) {
                x += ((Integer)entry.getKey()).intValue();
                y += ((Integer)entry.getValue()).intValue();
            }
        }
        List slots = container.field_75151_b;
        for (Slot slot : slots) {
            if (this.tileScreens.contains(screen.getClass()) && slot.getSlotIndex() == 0) {
                this.addSortingButton((Screen)screen, x, y + slot.field_75221_f, click -> this.sendSortMessage(0));
            }
            if (slot.field_75224_c != Minecraft.func_71410_x().field_71439_g.field_71071_by) continue;
            this.addSortingButton((Screen)screen, x, y + slot.field_75221_f, click -> this.sendSortMessage(1));
            break;
        }
        sortingButtons.forEach(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)event).addWidget(arg_0));
    }

    @SubscribeEvent
    public void onDrawForeground(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof InventoryScreen && !this.blacklistScreens.contains(event.getGuiContainer().getClass())) {
            InventoryScreen screen = (InventoryScreen)event.getGuiContainer();
            sortingButtons.forEach(button -> button.func_191746_c(screen.getGuiLeft() + 159, button.field_230691_m_));
        }
    }

    private void addSortingButton(Screen screen, int x, int y, Button.IPressable onPress) {
        sortingButtons.add(new ImageButton(x, y, 10, 10, 40, 0, 10, CharmResources.INVENTORY_BUTTONS, onPress));
    }

    private void sendSortMessage(int type) {
        Charm.PACKET_HANDLER.sendToServer(new ServerSortInventory(type));
    }
}

