/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.integration;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.server.ServerWorld;
import svenhjol.charm.Charm;
import svenhjol.charm.base.helper.PosHelper;
import svenhjol.charm.base.helper.StringHelper;
import svenhjol.charm.base.integration.IQuarkCompat;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.world.module.BigDungeonModule;

public class QuarkCompat
implements IQuarkCompat {
    @Override
    public boolean isModuleEnabled(String moduleName) {
        try {
            int dot = moduleName.lastIndexOf(".") + 1;
            String packageName = moduleName.substring(0, dot);
            String className = moduleName.substring(dot);
            Class<?> clazz = Class.forName("vazkii.quark.content." + packageName + StringHelper.snakeToUpperCamel(className));
            boolean isEnabled = ModuleLoader.INSTANCE.isModuleEnabled(clazz);
            Charm.LOG.debug("Quark " + clazz.toString() + " is " + (isEnabled ? "enabled" : "not enabled"));
            return isEnabled;
        }
        catch (Exception e) {
            Charm.LOG.debug("Failed to resolve Quark module class: " + moduleName);
            return false;
        }
    }

    @Override
    public boolean isInBigDungeon(PlayerEntity player) {
        if (player != null && player.field_70170_p != null && !player.field_70170_p.field_72995_K) {
            return PosHelper.isInsideStructure((ServerWorld)player.field_70170_p, player.func_233580_cy_(), BigDungeonModule.STRUCTURE);
        }
        return false;
    }
}

