/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.helper;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import svenhjol.charm.Charm;

public class PosHelper {
    public static BlockPos addRandomOffset(BlockPos pos, Random rand, int min, int max) {
        int n = rand.nextInt(max - min) + min;
        int e = rand.nextInt(max - min) + min;
        int s = rand.nextInt(max - min) + min;
        int w = rand.nextInt(max - min) + min;
        pos = pos.func_177964_d(rand.nextFloat() < 0.5f ? n : -n);
        pos = pos.func_177965_g(rand.nextFloat() < 0.5f ? e : -e);
        pos = pos.func_177970_e(rand.nextFloat() < 0.5f ? s : -s);
        pos = pos.func_177985_f(rand.nextFloat() < 0.5f ? w : -w);
        return pos;
    }

    public static double getDistanceSquared(BlockPos pos1, BlockPos pos2) {
        double d0 = pos1.func_177958_n();
        double d1 = pos1.func_177952_p();
        double d2 = d0 - (double)pos2.func_177958_n();
        double d3 = d1 - (double)pos2.func_177952_p();
        return d2 * d2 + d3 * d3;
    }

    public static boolean isInsideStructure(ServerWorld world, BlockPos pos, Structure<?> structure) {
        return world.func_241112_a_().func_235010_a_(pos, true, structure).func_75069_d();
    }

    public static boolean isLikeSolid(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return PosHelper.isSolid(world, pos) || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151585_k;
    }

    public static boolean isLikeAir(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return !state.func_200132_m() || state.func_185904_a() == Material.field_151586_h || state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151577_b;
    }

    public static boolean isSolid(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_200132_m() && !world.func_175623_d(pos) && !state.func_185904_a().func_76224_d();
    }

    @Nullable
    public static BlockPos getSurfacePos(World world, BlockPos pos) {
        int surface = 0;
        for (int y = world.func_217301_I(); y >= 0; --y) {
            BlockPos n = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            if (!world.func_175623_d(n) || world.func_175623_d(n.func_177977_b())) continue;
            surface = y;
            break;
        }
        if (surface <= 0) {
            Charm.LOG.warn("Failed to find a surface value to spawn the player");
            return null;
        }
        return new BlockPos(pos.func_177958_n(), surface, pos.func_177952_p());
    }
}

