/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.misc.WeightedOre;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.apache.commons.lang3.tuple.Pair;

public class OreSpawnEffect
implements IDrainSpotEffect {
    public static final Set<BlockState> SPAWN_EXCEPTIONS = new HashSet<BlockState>();
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "ore_spawn");
    private int amount;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(world, pos, 30);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura <= 2000000) {
            return false;
        }
        this.amount = Math.min(20, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 300000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.amount <= 0) {
            return false;
        }
        this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 150000), (int)5, (int)20);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(PlayerEntity player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!NaturesAuraAPI.instance().isEffectPowderActive(player.field_70170_p, player.func_233580_cy_(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((IItemProvider)Blocks.field_150482_ag);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (world.func_82737_E() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        type = auraChunk.getType();
        if (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD)) {
            requiredBlock = Blocks.field_150348_b;
            ores = NaturesAuraAPI.OVERWORLD_ORES;
        } else {
            requiredBlock = Blocks.field_150424_aL;
            ores = NaturesAuraAPI.NETHER_ORES;
        }
        totalWeight = WeightedRandom.func_76272_a(ores);
        powders = NaturesAuraAPI.instance().getActiveEffectPowders(world, new AxisAlignedBB(pos).func_186662_g((double)this.dist), OreSpawnEffect.NAME);
        if (powders.isEmpty()) {
            return;
        }
        for (i = 0; i < this.amount; ++i) {
            powder = powders.get(i % powders.size());
            powderPos = (Vector3d)powder.func_76341_a();
            range = (Integer)powder.func_76340_b();
            x = MathHelper.func_76128_c((double)(powderPos.field_72450_a + world.field_73012_v.nextGaussian() * (double)range));
            orePos = new BlockPos(x, y = MathHelper.func_76128_c((double)(powderPos.field_72448_b + world.field_73012_v.nextGaussian() * (double)range)), z = MathHelper.func_76128_c((double)(powderPos.field_72449_c + world.field_73012_v.nextGaussian() * (double)range)));
            if (!(orePos.func_218140_a(powderPos.field_72450_a, powderPos.field_72448_b, powderPos.field_72449_c, true) <= (double)(range * range)) || !(orePos.func_177951_i((Vector3i)pos) <= (double)(this.dist * this.dist)) || !world.func_175667_e(orePos) || (state = world.func_180495_p(orePos)).func_177230_c() != requiredBlock) continue;
            block1: while (true) {
                ore = (WeightedOre)WeightedRandom.func_76273_a((Random)world.field_73012_v, ores, (int)totalWeight);
                tag = world.func_205772_D().func_241835_a().func_199910_a(ore.tag);
                if (tag == null) continue;
                var22_22 = tag.func_230236_b_().iterator();
                while (true) {
                    if (var22_22.hasNext()) ** break;
                    continue block1;
                    toPlace = (Block)var22_22.next();
                    if (toPlace == null || toPlace == Blocks.field_150350_a) continue;
                    player = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
                    player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    ray = new BlockRayTraceResult(Vector3d.func_237489_a_((Vector3i)pos), Direction.UP, pos, false);
                    context = new BlockItemUseContext(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, ray));
                    stateToPlace = toPlace.func_196258_a(context);
                    if (!OreSpawnEffect.SPAWN_EXCEPTIONS.contains(stateToPlace)) break block1;
                }
                break;
            }
            world.func_175656_a(orePos, stateToPlace);
            world.func_217379_c(2001, orePos, Block.func_196246_j((BlockState)stateToPlace));
            toDrain = (20000 - ore.field_76292_a * 2) * 2;
            highestSpot = IAuraChunk.getHighestSpot((IWorld)world, orePos, 30, pos);
            IAuraChunk.getAuraChunk((IWorld)world, highestSpot).drainAura(highestSpot, toDrain);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.oreEffect.get() != false && (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) || type.isSimilar(NaturesAuraAPI.TYPE_NETHER));
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

