/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class AuraChunkProvider
implements ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    private final Chunk chunk;
    private final LazyOptional<IAuraChunk> lazyChunk = LazyOptional.of(this::getAuraChunk);
    private IAuraChunk auraChunk;

    public AuraChunkProvider(Chunk chunk) {
        this.chunk = chunk;
    }

    private IAuraChunk getAuraChunk() {
        if (this.auraChunk == null) {
            this.auraChunk = new AuraChunk(this.chunk, IAuraType.forWorld((IWorld)this.chunk.func_177412_p()));
        }
        return this.auraChunk;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == NaturesAuraAPI.capAuraChunk ? this.lazyChunk.cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)this.getAuraChunk().serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.getAuraChunk().deserializeNBT((INBT)nbt);
    }
}

