/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockImpl;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.ICustomRenderType;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.generators.ItemModelBuilder;

public class BlockGoldPowder
extends BlockImpl
implements IColorProvidingBlock,
ICustomBlockState,
ICustomItemModel,
ICustomRenderType {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)};

    public BlockGoldPowder() {
        super("gold_powder", AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150488_af));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE));
    }

    private static int getShapeIndex(BlockState state) {
        boolean w;
        int i = 0;
        boolean n = state.func_177229_b(NORTH) != RedstoneSide.NONE;
        boolean e = state.func_177229_b(EAST) != RedstoneSide.NONE;
        boolean s = state.func_177229_b(SOUTH) != RedstoneSide.NONE;
        boolean bl = w = state.func_177229_b(WEST) != RedstoneSide.NONE;
        if (n || s && !n && !e && !w) {
            i |= 1 << Direction.NORTH.func_176736_b();
        }
        if (e || w && !n && !e && !s) {
            i |= 1 << Direction.EAST.func_176736_b();
        }
        if (s || n && !e && !s && !w) {
            i |= 1 << Direction.SOUTH.func_176736_b();
        }
        if (w || e && !n && !s && !w) {
            i |= 1 << Direction.WEST.func_176736_b();
        }
        return i;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public IBlockColor getBlockColor() {
        return (state, worldIn, pos, tintIndex) -> 16042818;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[BlockGoldPowder.getShapeIndex(state)];
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(WEST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.WEST))).func_206870_a(EAST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.EAST))).func_206870_a(NORTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.NORTH))).func_206870_a(SOUTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.SOUTH));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        return facing == Direction.UP ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a(WEST, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.WEST))).func_206870_a(EAST, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.EAST))).func_206870_a(NORTH, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.NORTH))).func_206870_a(SOUTH, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.SOUTH)) : (BlockState)stateIn.func_206870_a((Property)RedstoneWireBlock.field_196498_A.get(facing), (Comparable)this.getSide((IBlockReader)worldIn, currentPos, facing));
    }

    private RedstoneSide getSide(IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.func_177972_a(face);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        BlockPos blockpos1 = pos.func_177984_a();
        BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
        if (!blockstate1.func_215686_e(worldIn, blockpos1)) {
            boolean flag;
            boolean bl = flag = blockstate.func_224755_d(worldIn, blockpos, Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
            if (flag && this.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()))) {
                if (blockstate.func_235785_r_(worldIn, blockpos)) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !this.canConnectTo(blockstate) && (blockstate.func_215686_e(worldIn, blockpos) || !this.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    protected boolean canConnectTo(BlockState blockState) {
        Block block = blockState.func_177230_c();
        return block == this;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction1));
            }
            for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(direction2);
                if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction1));
                }
                for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                    BlockPos blockpos = pos.func_177972_a(direction2);
                    if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos)) {
                        this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                        continue;
                    }
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K && !state.func_196955_c((IWorldReader)worldIn, pos)) {
            BlockGoldPowder.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.Mutable pool = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)RedstoneWireBlock.field_196498_A.get(direction));
            if (redstoneside == RedstoneSide.NONE || worldIn.func_180495_p((BlockPos)pool.func_189533_g((Vector3i)pos).func_189536_c(direction)).func_177230_c() == this) continue;
            pool.func_189536_c(Direction.DOWN);
            BlockState blockstate = worldIn.func_180495_p((BlockPos)pool);
            if (blockstate.func_177230_c() != Blocks.field_190976_dk) {
                BlockPos blockpos = pool.func_177972_a(direction.func_176734_d());
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos), worldIn, (BlockPos)pool, blockpos);
                BlockGoldPowder.func_196263_a((BlockState)blockstate, (BlockState)blockstate1, (IWorld)worldIn, (BlockPos)pool, (int)flags);
            }
            pool.func_189533_g((Vector3i)pos).func_189536_c(direction).func_189536_c(Direction.UP);
            BlockState blockstate3 = worldIn.func_180495_p((BlockPos)pool);
            if (blockstate3.func_177230_c() == Blocks.field_190976_dk) continue;
            BlockPos blockpos1 = pool.func_177972_a(direction.func_176734_d());
            BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos1), worldIn, (BlockPos)pool, blockpos1);
            BlockGoldPowder.func_196263_a((BlockState)blockstate3, (BlockState)blockstate2, (IWorld)worldIn, (BlockPos)pool, (int)flags);
        }
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "item/" + this.getBaseName());
    }

    @Override
    public Supplier<RenderType> getRenderType() {
        return RenderType::func_228641_d_;
    }
}

