/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.tiles.TileEntityEndFlower;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.ICustomRenderType;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import de.ellpeck.naturesaura.reg.ModTileType;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockEndFlower
extends BushBlock
implements IModItem,
ICustomBlockState,
ICustomItemModel,
ICustomRenderType {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public BlockEndFlower() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200943_b(0.5f).func_200947_a(SoundType.field_185850_c));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModRegistry.add(this);
        ModRegistry.add(new ModTileType<TileEntityEndFlower>(TileEntityEndFlower::new, this));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vec3d = state.func_191059_e(worldIn, pos);
        return SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    @SubscribeEvent
    public void onDragonTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K || !(living instanceof EnderDragonEntity)) {
            return;
        }
        EnderDragonEntity dragon = (EnderDragonEntity)living;
        if (dragon.field_70995_bG < 150 || dragon.field_70995_bG % 10 != 0) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int z;
            int x = dragon.field_70170_p.field_73012_v.nextInt(256) - 128;
            BlockPos pos = new BlockPos(x, dragon.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = dragon.field_70170_p.field_73012_v.nextInt(256) - 128), z);
            if (!dragon.field_70170_p.func_175667_e(pos) || dragon.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150377_bs) continue;
            dragon.field_70170_p.func_175656_a(pos, this.func_176223_P());
        }
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150377_bs;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150377_bs;
    }

    @Override
    public String getBaseName() {
        return "end_flower";
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityEndFlower();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof TileEntityEndFlower && ((TileEntityEndFlower)tile).isDrainMode) {
            return NonNullList.func_191196_a();
        }
        return super.func_220076_a(state, builder);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cross(this.getBaseName(), generator.modLoc("block/" + this.getBaseName())));
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "block/" + this.getBaseName());
    }

    @Override
    public Supplier<RenderType> getRenderType() {
        return RenderType::func_228643_e_;
    }
}

