/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import de.ellpeck.naturesaura.blocks.multi.Multiblock;
import de.ellpeck.naturesaura.misc.WorldData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;

public class InternalHooks
implements NaturesAuraAPI.IInternalHooks {
    @Override
    public boolean extractAuraFromPlayer(PlayerEntity player, int amount, boolean simulate) {
        return this.auraPlayerInteraction(player, amount, true, simulate);
    }

    @Override
    public boolean insertAuraIntoPlayer(PlayerEntity player, int amount, boolean simulate) {
        return this.auraPlayerInteraction(player, amount, false, simulate);
    }

    private boolean auraPlayerInteraction(PlayerEntity player, int amount, boolean extract, boolean simulate) {
        if (extract && player.func_184812_l_()) {
            return true;
        }
        ItemStack stack = Helper.getEquippedItem(s -> s.getCapability(NaturesAuraAPI.capAuraContainer).isPresent(), player);
        if (!stack.func_190926_b()) {
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer).orElse(null);
            amount = extract ? (amount -= container.drainAura(amount, simulate)) : (amount -= container.storeAura(amount, simulate));
            return amount <= 0;
        }
        return false;
    }

    @Override
    public void spawnMagicParticle(double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, float gravity, boolean collision, boolean fade) {
        NaturesAura.proxy.spawnMagicParticle(posX, posY, posZ, motionX, motionY, motionZ, color, scale, maxAge, gravity, collision, fade);
    }

    @Override
    public void spawnParticleStream(float startX, float startY, float startZ, float endX, float endY, float endZ, float speed, int color, float scale) {
        Vector3d dir = new Vector3d((double)(endX - startX), (double)(endY - startY), (double)(endZ - startZ));
        double length = dir.func_72433_c();
        if (length > 0.0) {
            dir = dir.func_72432_b();
            this.spawnMagicParticle(startX, startY, startZ, dir.field_72450_a * (double)speed, dir.field_72448_b * (double)speed, dir.field_72449_c * (double)speed, color, scale, (int)(length / (double)speed), 0.0f, false, false);
        }
    }

    @Override
    public void setParticleDepth(boolean depth) {
        NaturesAura.proxy.setParticleDepth(depth);
    }

    @Override
    public void setParticleSpawnRange(int range) {
        NaturesAura.proxy.setParticleSpawnRange(range);
    }

    @Override
    public void setParticleCulling(boolean cull) {
        NaturesAura.proxy.setParticleCulling(cull);
    }

    @Override
    public IMultiblock createMultiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        return new Multiblock(name, pattern, rawMatchers);
    }

    @Override
    public List<Tuple<Vector3d, Integer>> getActiveEffectPowders(World world, AxisAlignedBB area, ResourceLocation name) {
        ArrayList<Tuple<Vector3d, Integer>> found = new ArrayList<Tuple<Vector3d, Integer>>();
        for (Tuple powder : ((WorldData)IWorldData.getWorldData((World)world)).effectPowders.get((Object)name)) {
            if (!area.func_72318_a((Vector3d)powder.func_76341_a())) continue;
            found.add((Tuple<Vector3d, Integer>)powder);
        }
        return found;
    }

    @Override
    public boolean isEffectPowderActive(World world, BlockPos pos, ResourceLocation name) {
        Vector3d posVec = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        List<Tuple<Vector3d, Integer>> powders = this.getActiveEffectPowders(world, new AxisAlignedBB(pos).func_186662_g(64.0), name);
        for (Tuple<Vector3d, Integer> powder : powders) {
            AxisAlignedBB bounds = Helper.aabb((Vector3d)powder.func_76341_a()).func_186662_g((double)((Integer)powder.func_76340_b()).intValue());
            if (!bounds.func_72318_a(posVec)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getAuraSpotsInArea(World world, BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        Helper.getAuraChunksWithSpotsInArea(world, pos, radius, chunk -> chunk.getSpotsInArea(pos, radius, consumer));
    }

    @Override
    public int getSpotAmountInArea(World world, BlockPos pos, int radius) {
        MutableInt result = new MutableInt();
        this.getAuraSpotsInArea(world, pos, radius, (blockpos, drainSpot) -> result.increment());
        return result.intValue();
    }

    @Override
    public int getAuraInArea(World world, BlockPos pos, int radius) {
        MutableInt result = new MutableInt(1000000);
        this.getAuraSpotsInArea(world, pos, radius, (blockPos, drainSpot) -> result.add((Number)drainSpot));
        return result.intValue();
    }

    @Override
    public Pair<Integer, Integer> getAuraAndSpotAmountInArea(World world, BlockPos pos, int radius) {
        MutableInt spots = new MutableInt();
        MutableInt aura = new MutableInt(1000000);
        this.getAuraSpotsInArea(world, pos, radius, (blockPos, drainSpot) -> {
            aura.add((Number)drainSpot);
            spots.increment();
        });
        return Pair.of((Object)aura.intValue(), (Object)spots.intValue());
    }

    @Override
    public int triangulateAuraInArea(World world, BlockPos pos, int radius) {
        MutableFloat result = new MutableFloat(1000000.0f);
        IAuraChunk.getSpotsInArea((IWorld)world, pos, radius, (blockPos, spot) -> {
            float percentage = 1.0f - (float)Math.sqrt(pos.func_177951_i((Vector3i)blockPos)) / (float)radius;
            result.add((float)spot.intValue() * percentage);
        });
        return result.intValue();
    }

    @Override
    public BlockPos getLowestAuraDrainSpot(World world, BlockPos pos, int radius, BlockPos defaultSpot) {
        MutableInt lowestAmount = new MutableInt(Integer.MAX_VALUE);
        MutableObject lowestSpot = new MutableObject();
        this.getAuraSpotsInArea(world, pos, radius, (blockPos, drainSpot) -> {
            if (drainSpot < lowestAmount.intValue()) {
                lowestAmount.setValue((Number)drainSpot);
                lowestSpot.setValue(blockPos);
            }
        });
        BlockPos lowest = (BlockPos)lowestSpot.getValue();
        if (lowest == null || lowestAmount.intValue() >= 0) {
            lowest = defaultSpot;
        }
        return lowest;
    }

    @Override
    public BlockPos getHighestAuraDrainSpot(World world, BlockPos pos, int radius, BlockPos defaultSpot) {
        MutableInt highestAmount = new MutableInt(Integer.MIN_VALUE);
        MutableObject highestSpot = new MutableObject();
        this.getAuraSpotsInArea(world, pos, radius, (blockPos, drainSpot) -> {
            if (drainSpot > highestAmount.intValue()) {
                highestAmount.setValue((Number)drainSpot);
                highestSpot.setValue(blockPos);
            }
        });
        BlockPos highest = (BlockPos)highestSpot.getValue();
        if (highest == null || highestAmount.intValue() <= 0) {
            highest = defaultSpot;
        }
        return highest;
    }
}

