/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.util;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class Util {
    public static ResourceLocation res(String domainAndPath) {
        return new ResourceLocation(domainAndPath);
    }

    public static ResourceLocation res(String modid, String path) {
        return new ResourceLocation(modid, path);
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && stack.func_190916_E() > 0 && !stack.func_190926_b() && !stack.func_77973_b().equals(Items.field_190931_a);
    }

    public static boolean equalExceptAmount(ItemStack stack1, ItemStack stack2) {
        if (!Util.isValid(stack1) && !Util.isValid(stack2)) {
            return true;
        }
        if (!Util.isValid(stack1) && Util.isValid(stack2)) {
            return false;
        }
        if (Util.isValid(stack1) && !Util.isValid(stack2)) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && (!stack1.func_77942_o() && !stack2.func_77942_o() || stack1.func_77978_p().equals((Object)stack2.func_77978_p()));
    }

    public static ItemStack stack(Object object) {
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        if (object instanceof Block) {
            return new ItemStack((IItemProvider)((Block)object));
        }
        if (object instanceof Item) {
            return new ItemStack((IItemProvider)((Item)object));
        }
        throw new InvalidParameterException("Object of type" + object.getClass() + " cannot be made into an ItemStack.");
    }

    public static FluidStack fluidStack(Fluid f) {
        return new FluidStack(f, 1000);
    }

    public static Set<BlockState> getAllStates(Block blockIn) {
        return ImmutableSet.copyOf((Collection)blockIn.func_176194_O().func_177619_a());
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... objs) {
        LinkedList<T> list = new LinkedList<T>();
        for (T t : objs) {
            list.add(t);
        }
        return list;
    }

    @SafeVarargs
    public static <E> NonNullList<E> nnl(E ... items) {
        NonNullList list = NonNullList.func_191196_a();
        for (E item : items) {
            list.add(item);
        }
        return list;
    }

    @SafeVarargs
    public static <T> T[] array(T ... items) {
        return items;
    }

    public static ItemStack[] stackArray(Object ... items) {
        ItemStack[] arr = new ItemStack[items.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Util.stack(items[i]);
        }
        return arr;
    }

    public static <T> T getRandomFromArray(T[] arr) {
        return arr[(int)(Math.random() * (double)arr.length)];
    }

    public static boolean listContains(List<ItemStack> list, Item item) {
        for (ItemStack stack : list) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static void spawnItem(World world, Vector3i pos, ItemStack stack) {
        Util.spawnItem(world, new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), stack, 10, new double[0]);
    }

    public static void spawnItem(World world, Vector3d pos, ItemStack stack) {
        Util.spawnItem(world, pos, stack, 10, new double[0]);
    }

    public static void spawnItem(World world, Vector3d pos, ItemStack stack, int pickupDelay, double ... speeds) {
        if (!Util.isValid(stack)) {
            return;
        }
        ItemEntity entityitem = new ItemEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), stack);
        if (speeds.length == 0) {
            entityitem.func_213317_d(new Vector3d(Math.random() * 0.4 - 0.2, Math.random() * 0.2, Math.random() * 0.4 - 0.2));
        } else {
            entityitem.func_213317_d(new Vector3d(speeds[0], speeds[1], speeds[2]));
        }
        entityitem.func_174867_a(pickupDelay);
        world.func_217376_c((Entity)entityitem);
    }

    public static <T> T getObjectFromField(Class<?> class1, String fieldName, Object obj) {
        Field field = Util.getField(class1, fieldName);
        field.setAccessible(true);
        return Util.getObjectFromField(field, obj);
    }

    public static IItemProvider randomDye() {
        switch ((int)(Math.random() * 16.0)) {
            case 0: {
                return Items.field_222086_lz;
            }
            case 1: {
                return Items.field_222083_lx;
            }
            case 2: {
                return Items.field_222085_ly;
            }
            case 3: {
                return Items.field_196124_bl;
            }
            case 4: {
                return Items.field_196120_bj;
            }
            case 5: {
                return Items.field_222079_lj;
            }
            case 6: {
                return Items.field_196112_bf;
            }
            case 7: {
                return Items.field_196122_bk;
            }
            case 8: {
                return Items.field_196116_bh;
            }
            case 9: {
                return Items.field_196110_be;
            }
            case 10: {
                return Items.field_196108_bd;
            }
            case 11: {
                return Items.field_196118_bi;
            }
            case 12: {
                return Items.field_196126_bm;
            }
            case 13: {
                return Items.field_222078_li;
            }
            case 14: {
                return Items.field_222069_lA;
            }
            case 15: {
                return Items.field_222081_ls;
            }
        }
        return null;
    }

    public static boolean blockIsNearBlock(World world, BlockPos pos, Block block) {
        for (Direction dir : Direction.values()) {
            if (world.func_180495_p(pos.func_177972_a(dir)).func_177230_c() != block) continue;
            return true;
        }
        return false;
    }

    private static Field getField(Class<?> class1, String fieldName) {
        try {
            return class1.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException("could not get field " + fieldName + " from class " + class1.getName());
        }
    }

    private static <T> T getObjectFromField(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("could not get object " + obj + " from field " + field.getName());
        }
    }
}

