/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import wolforce.mctcg.container.deckbox.InventoryDeckbox;
import wolforce.mctcg.items.ItemCard;
import wolforce.mctcg.items.ItemDeckbox;
import wolforce.mctcg.util.Util;

public class Attributes {
    private static final String NBT_ID = "attributes";
    private HashMap<String, Integer> attributes = new HashMap();

    public static void saveAttributes(InventoryDeckbox deckInv) {
        Attributes attributes = new Attributes(deckInv);
        CompoundNBT attrNBT = new CompoundNBT();
        for (String attribute : attributes.attributes.keySet()) {
            attrNBT.func_74768_a(attribute, attributes.attributes.get(attribute).intValue());
        }
        deckInv.setAttributes(NBT_ID, attrNBT);
    }

    public Attributes(InventoryDeckbox deckInv) {
        int[] sources = new int[ItemCard.EnumSource.values().length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = 0;
        }
        boolean resourceStacking = true;
        while (resourceStacking) {
            for (int i = 0; i < deckInv.getSlots(); ++i) {
                ItemStack slotStack = deckInv.getStackInSlot(i).getStack();
                if (!Util.isValid(slotStack) || !(slotStack.func_77973_b() instanceof ItemCard)) continue;
                ItemCard card = (ItemCard)slotStack.func_77973_b();
                int n = card.source.ordinal();
                sources[n] = sources[n] + card.produce;
                if (!card.activateable || !Attributes.trySubtractSources(sources, card.costs)) continue;
                this.add(card.regName);
            }
            resourceStacking = false;
        }
    }

    public Attributes(PlayerEntity player) {
        this(Attributes.findDeckbox(player));
    }

    public Attributes(ItemStack stack) {
        if (!Util.isValid(stack)) {
            return;
        }
        CompoundNBT stackNBT = stack.func_196082_o();
        if (!stackNBT.func_74764_b(NBT_ID)) {
            return;
        }
        CompoundNBT attrNBT = stackNBT.func_74775_l(NBT_ID);
        for (String id : attrNBT.func_150296_c()) {
            this.add(id, attrNBT.func_74762_e(id));
        }
    }

    private void add(String regName) {
        this.add(regName, 1);
    }

    private void add(String regName, int value) {
        int prevValue = 0;
        if (this.attributes.containsKey(regName)) {
            prevValue = this.attributes.get(regName);
        }
        this.attributes.put(regName, Math.min(3, prevValue + value));
    }

    public int get(String regName) {
        if (this.attributes.containsKey(regName)) {
            return this.attributes.get(regName);
        }
        return 0;
    }

    public int get(ItemCard card) {
        if (this.attributes.containsKey(card.regName)) {
            return this.attributes.get(card.regName);
        }
        return 0;
    }

    public boolean has(String regName) {
        return this.attributes.containsKey(regName) && this.attributes.get(regName) > 0;
    }

    public boolean has(ItemCard card) {
        return this.attributes.containsKey(card.regName) && this.attributes.get(card.regName) > 0;
    }

    private static ItemStack findDeckbox(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!(stack.func_77973_b() instanceof ItemDeckbox) || !((ItemDeckbox)stack.func_77973_b()).isDeck) continue;
            return stack;
        }
        return null;
    }

    private static boolean trySubtractSources(int[] resources, int[] costs) {
        int i;
        for (i = 0; i < costs.length; ++i) {
            if (resources[i] >= costs[i]) continue;
            return false;
        }
        for (i = 0; i < costs.length; ++i) {
            int n = i;
            resources[n] = resources[n] - costs[i];
        }
        return true;
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public Set<Map.Entry<String, Integer>> getAll() {
        return this.attributes.entrySet();
    }
}

