/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.items;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import wolforce.mctcg.MCTCG;
import wolforce.mctcg.container.cardbox.ContainerCardbox;
import wolforce.mctcg.container.deckbox.ContainerDeckbox;
import wolforce.mctcg.container.deckbox.InventoryDeckbox;
import wolforce.mctcg.items.ItemCard;
import wolforce.mctcg.util.Attributes;

public class ItemDeckbox
extends Item {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER;
    public final boolean isDeck;

    public ItemDeckbox(Item.Properties properties, boolean isDeck) {
        super(properties);
        this.isDeck = isDeck;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K || !(player instanceof ServerPlayerEntity) || !(stack.func_77973_b() instanceof ItemDeckbox)) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)(this.isDeck ? ContainerDeckbox.getServerContainerProvider(stack, player.field_71071_by) : ContainerCardbox.getServerContainerProvider(stack, player.field_71071_by)));
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        return new ICapabilityProvider(){
            final InventoryDeckbox itemHandler;
            final LazyOptional<IItemHandler> itemHandlerInstance;
            {
                this.itemHandler = new InventoryDeckbox(stack, ItemDeckbox.this.isDeck ? 20 : 104);
                this.itemHandlerInstance = LazyOptional.of(() -> this.itemHandler);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ITEM_HANDLER) {
                    return this.itemHandlerInstance.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Attributes attributes = new Attributes(stack);
        if (!attributes.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent("Activated cards:"));
            for (Map.Entry<String, Integer> attribute : attributes.getAll()) {
                ItemCard card = MCTCG.getCard(attribute.getKey());
                int value = attribute.getValue();
                tooltip.add((ITextComponent)new StringTextComponent("- " + card.title + " x" + value));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

