/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ItemCard
extends Item {
    public static Item.Properties properties;
    public final ResourceLocation texture;
    public final EnumRarity field_208075_l;
    public final int[] costs = new int[EnumSource.values().length];
    public final String regName;
    public final String textLines;
    public final String title;
    public final EnumCardType type;
    public final EnumSource source;
    public final int produce;
    public final boolean activateable;
    public String artist;

    public ItemCard(Item.Properties properties, EnumCardType type, String regName, String title, EnumRarity rarity, EnumSource source, int produce, boolean activateable, String textLines, EnumSource ... costsInputs) {
        super(properties);
        this.regName = "card_" + regName;
        this.type = type;
        this.title = title;
        this.field_208075_l = rarity;
        this.source = source;
        this.produce = produce;
        this.textLines = textLines;
        this.texture = new ResourceLocation("mctcg", "textures/cards/" + regName + ".png");
        for (EnumSource res : costsInputs) {
            int n = res.ordinal();
            this.costs[n] = this.costs[n] + 1;
        }
        this.activateable = activateable;
        this.artist = "Wolforce";
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.type != EnumCardType.Source) {
            if (this.type != EnumCardType.Rules) {
                tooltip.add((ITextComponent)new StringTextComponent("Cost: " + this.getCost()));
            }
            tooltip.add((ITextComponent)new StringTextComponent(this.textLines));
        }
        tooltip.add((ITextComponent)new StringTextComponent("\u00a78Illustration by: " + this.artist));
    }

    protected String func_195935_o() {
        return this.field_208075_l.colorCode + this.title + " (" + this.field_208075_l.name() + " " + this.type.name() + " Card)";
    }

    public ITextComponent func_200296_o() {
        return new StringTextComponent(this.field_208075_l.colorCode + this.title + " (" + this.type.name() + ")");
    }

    private String getCost() {
        String ret = "";
        for (int i = 0; i < this.costs.length; ++i) {
            EnumSource res = EnumSource.values()[i];
            if (this.costs[i] <= 0) continue;
            ret = ret + " " + res.colorCode + this.costs[i] + "x" + res.name().replaceAll("_", " ");
        }
        return ret;
    }

    public static enum EnumRarity {
        Common("", new ResourceLocation("minecraft:textures/item/coal.png")),
        Uncommon("\u00a72", new ResourceLocation("minecraft:textures/item/gold_ingot.png")),
        Rare("\u00a79", new ResourceLocation("minecraft:textures/item/redstone.png")),
        Epic("\u00a75", new ResourceLocation("minecraft:textures/item/diamond.png")),
        Legendary("\u00a76", new ResourceLocation("minecraft:textures/item/netherite_scraps.png")),
        Mythic("\u00a74", new ResourceLocation("minecraft:textures/item/nether_star.png")),
        Rules("", new ResourceLocation("minecraft:textures/item/nether_star.png"));

        public final String colorCode;
        public final ResourceLocation texture;

        private EnumRarity(String colorCode, ResourceLocation texture) {
            this.colorCode = colorCode;
            this.texture = texture;
        }
    }

    public static enum EnumSource {
        Soil("\u00a78"),
        Void("\u00a75"),
        Water("\u00a71"),
        Lava("\u00a76"),
        Flora("\u00a7a"),
        Fauna("\u00a77"),
        Mind("\u00a7c"),
        Mob("\u00a74");

        public final String colorCode;

        private EnumSource(String colorCode) {
            this.colorCode = colorCode;
        }
    }

    public static enum EnumCardType {
        Rules,
        Source,
        Action,
        Fate,
        Rune;

    }

    public static class CardWithArtist
    extends Card {
        public CardWithArtist(String regName, String title, EnumCardType type, String textLines, String artist, EnumSource ... costsInputs) {
            super(regName, title, type, textLines, costsInputs);
            this.artist = artist;
        }
    }

    public static class Card
    extends ItemCard {
        public static EnumRarity nextRarity;

        public Card(String regName, String title, EnumCardType type, String textLines, EnumSource ... costsInputs) {
            super(properties, type, regName, title, nextRarity, costsInputs[0], 0, true, textLines, costsInputs);
        }
    }

    public static class CardRareSourceWithArtist
    extends CardRareSource {
        public CardRareSourceWithArtist(String regName, String title, String artist, EnumSource source) {
            super(regName, title, source);
            this.artist = artist;
        }
    }

    public static class CardRareSource
    extends ItemCard {
        public CardRareSource(String regName, String title, EnumSource source) {
            super(properties, EnumCardType.Source, regName, title, EnumRarity.Rare, source, 3, false, "", new EnumSource[0]);
        }
    }

    public static class CardSource
    extends ItemCard {
        public CardSource(String regName, String title, EnumSource source) {
            super(properties, EnumCardType.Source, regName, title, EnumRarity.Common, source, 1, false, "", new EnumSource[0]);
        }
    }
}

